<?php
// ---------- PHP Section ----------
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ini_set('session.gc_maxlifetime', 86400);
ini_set('session.cookie_lifetime', 86400);
session_start();

include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit;
}

$user_phone = $_SESSION['phone'];

// Default values
$s_level = "S0";
$invite_code = "XXXXXX";
$electronic_wallet = 0;
$funds_to_be_released = 0;
$my_nlc = 0;

$stmt = $conn->prepare("SELECT id, username, invite_code, electronic_wallet, flexible_wallet, nlc_points, s_level, s_logo FROM users WHERE phone = ?");
$stmt->execute([$user_phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    $user_id = $user['id'];
    $username = $user['username'];
    $invite_code = $user['invite_code'];
    $electronic_wallet = $user['electronic_wallet'];
    $funds_to_be_released = $user['flexible_wallet'];
    $my_nlc = $user['nlc_points'];
    $s_level = (isset($user['s_level']) && strtoupper($user['s_level']) !== 'VIP0') ? $user['s_level'] : 'S0';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>User Center</title>

<!-- Font Awesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<style>
body {
  margin: 0;
  font-family: 'Poppins', sans-serif;
  background: #000;
  color: #fff;
}

/* Profile */
.profile {
  display: flex;
  align-items: center;
  padding: 20px 16px;
  background: #111;
}
.profile img {
  width: 60px;
  height: 60px;
  border-radius: 50%;
  margin-right: 14px;
}
.profile-info { flex: 1; }
.profile-info h2 {
  margin: 0;
  font-size: 1rem;
  font-weight: 600;
}
.profile-info p {
  margin: 3px 0;
  font-size: 0.8rem;
  color: #ccc;
}
.profile-badge {
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;
  gap: 6px;
}
.profile-badge .level-text {
  color: #FFD76E;
  font-size: 0.85rem;
  font-weight: bold;
}
.profile-badge img {
  width: 35px;
  height: 35px;
  border-radius: 50%;
}

/* Wallet */
.wallet-card {
  background: linear-gradient(180deg, #FFFFFF 0%, #FFEAB6 100%);
  border-radius: 12px;
  margin: 17px;
  padding: 12px 0;
  display: flex;
  justify-content: space-around;
  text-align: center;
  color: #000;
}
.wallet-item {
  display: flex;
  flex-direction: column;
  align-items: center;
  position: relative;
}
.wallet-icon {
  background: #000;
  width: 38px;
  height: 38px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-bottom: 8px;
  box-shadow: 0 0 6px rgba(0,0,0,0.4);
}
.wallet-icon i {
  font-size: 18px;
  color: #FFD76E;
}
.wallet-item p { 
  margin: 2px 0; 
  font-size: 0.8rem; 
  color: #000; 
  font-weight: bold; 
}
.wallet-item h3 { 
  margin: 4px 0; 
  font-size: 0.9rem; 
  font-weight: 700; 
}

/* Line between wallet sections */
.wallet-item:nth-child(2) {
  border-left: 1px solid #ccc;
  border-right: 1px solid #ccc;
  padding: 0 10px;
}

/* List */
.list { margin: 0; }
.list-item {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 14px 18px;
  border-bottom: 1px solid #1a1a1a;
  color: #fff;
  cursor: pointer;
}
.list-item:hover { background: #111; }
.list-left { display: flex; align-items: center; }
.list-left i { color: #FFD76E; margin-right: 10px; font-size: 18px; }
.list-item i.fa-angle-right { color: #999; }

/* Logout */
.logout {
  background: #1c1c1c;
  color: #fff;
  border: none;
  padding: 14px;
  border-radius: 10px;
  width: calc(100% - 20px);
  margin: 30px 10px 10px;
  font-size: 1rem;
  cursor: pointer;
}
.logout:hover { background: #333; }

/* Simple centered video popup */
#videoModal {
  display: none;
  position: fixed;
  z-index: 2000;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  background: rgba(0,0,0,0.8);
  justify-content: center;
  align-items: center;
}

#videoModal.active {
  display: flex;
}

.video-wrapper {
  display: flex;
  flex-direction: column;
  align-items: center;
}

.video-box {
  width: 90%;
  max-width: 400px;
  border-radius: 12px;
  overflow: hidden;
  background: #000;
}

.video-box video {
  width: 100%;
  height: auto;
  display: block;
}

.close-video {
  margin-top: 15px;
  background: rgba(255, 255, 255, 0.15);
  color: #fff;
  border: none;
  border-radius: 50%;
  width: 40px;
  height: 40px;
  font-size: 22px;
  line-height: 40px;
  text-align: center;
  cursor: pointer;
  backdrop-filter: blur(3px);
  transition: background 0.25s ease;
}

.close-video:hover {
  background: rgba(255, 255, 255, 0.3);
}
</style>
</head>

<body>

<div id="videoModal">
  <div class="video-wrapper">
    <div class="video-box">
      <video id="officialVideo" controls>
        <source src="/official.mp4" type="video/mp4">
        Your browser does not support the video tag.
      </video>
    </div>
    <button class="close-video" onclick="closeVideo()">×</button>
  </div>
</div>


<!-- Profile -->
<div class="profile">
  <img src="/uploads/logo.jpg" alt="Avatar">
  <div class="profile-info">
    <h2><?php echo htmlspecialchars($username ?? 'User'); ?></h2>
    <p>ID : <?php echo htmlspecialchars($user_id); ?> 
       <i class="fa-solid fa-copy" onclick="copyText('<?php echo $user_id; ?>')" 
          style="font-size:0.8rem; color:#FFD76E; cursor:pointer;"></i>
    </p>
    <p>Invite Code: <strong><?php echo htmlspecialchars($invite_code); ?></strong></p>
  </div>
  <div class="profile-badge">
    <span class="level-text"><?php echo htmlspecialchars($s_level); ?></span>
    <img src="<?php echo htmlspecialchars($user['s_logo'] ?? 's0.png'); ?>" alt="Badge">
  </div>
</div>

<!-- Wallet -->
<div class="wallet-card">
  <div class="wallet-item" onclick="location.href='transfer.php'">
    <div class="wallet-icon"><i class="fa-solid fa-coins"></i></div>
    <p>USD <?php echo number_format($electronic_wallet, 2); ?></p>
    <h3>E-wallet</h3>
  </div>
  <div class="wallet-item" onclick="location.href='index1.php'">
    <div class="wallet-icon"><i class="fa-solid fa-money-bill-wave"></i></div>
    <p>USD <?php echo number_format($funds_to_be_released, 2); ?></p>
    <h3>Unreleased Bonus</h3>
  </div>
  <div class="wallet-item" onclick="location.href='points_record.php'">
    <div class="wallet-icon"><i class="fa-solid fa-shuffle"></i></div>
    <p>USD <?php echo number_format($my_nlc, 2); ?></p>
    <h3>Member Point</h3>
  </div>
</div>

<!-- Options -->
<div class="list">
  <div class="list-item" onclick="location.href='verify.php'">
    <div class="list-left"><i class="fa-solid fa-id-card"></i><span>User KYC</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  
  <div class="list-item" onclick="location.href='change_login_password.php'">
    <div class="list-left"><i class="fa-solid fa-lock"></i><span>Login Password</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  <div class="list-item" onclick="location.href='transaction_password.php'">
    <div class="list-left"><i class="fa-solid fa-key"></i><span>Transaction Password</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  <div class="list-item" onclick="openVideo()">
    <div class="list-left"><i class="fa-solid fa-video"></i><span>Official Video</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  <div class="list-item" onclick="location.href='notifications.php'">
    <div class="list-left"><i class="fa-solid fa-bell"></i><span>Notification</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  <div class="list-item" onclick="location.href='leng.php'">
    <div class="list-left"><i class="fa-solid fa-language"></i><span>Switch Language</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  <div class="list-item" onclick="location.href=''">
    <div class="list-left"><i class="fa-solid fa-headset"></i><span>Contact Customer Service</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  <div class="list-item" onclick="location.href=''">
    <div class="list-left"><i class="fa-solid fa-mobile-screen-button"></i><span>App Download</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
  <div class="list-item" onclick="location.href='about_us.php'">
    <div class="list-left"><i class="fa-solid fa-globe"></i><span>Official Link</span></div>
    <i class="fa-solid fa-angle-right"></i>
  </div>
</div>

<!-- Logout -->
<form action="logout.php" method="POST">
  <button type="submit" class="logout">Logout</button>
</form>

<script>
function copyText(text) {
  navigator.clipboard.writeText(text);
}

function openVideo() {
  const modal = document.getElementById('videoModal');
  modal.classList.add('active');
  const video = document.getElementById('officialVideo');
  video.currentTime = 0;
  video.play();
}

function closeVideo() {
  const modal = document.getElementById('videoModal');
  modal.classList.remove('active');
  const video = document.getElementById('officialVideo');
  video.pause();
}
</script>

<?php include 'bottom_nav.php'; ?>
</body>
</html>