
<?php  
session_start();  

include 'db.php';             // Your PDO connection file  
  
// Initialize messages  
$message = '';  
$success = '';  
  
if ($_SERVER['REQUEST_METHOD'] === 'POST') {  
    $login_type  = $_POST['login_type'] ?? ''; // "username" or "email"  
    $login_value = trim($_POST['login_value'] ?? '');  
    $password    = trim($_POST['password'] ?? '');  
  
    if (empty($login_value) || empty($password)) {  
        $message = "Please fill in all fields.";  
    } else {  
        try {  
            // Select by username or email  
            if ($login_type === 'username') {  
                $stmt = $conn->prepare("SELECT * FROM users WHERE username = ? LIMIT 1");  
            } else {  
                $stmt = $conn->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");  
            }  
            $stmt->execute([$login_value]);  
  
            if ($stmt->rowCount() > 0) {  
                $user = $stmt->fetch(PDO::FETCH_ASSOC);  
  
                // Check password (hashed or plaintext)  
                if (password_verify($password, $user['password']) || $password === $user['password']) {  
                    if (!empty($user['is_banned']) && $user['is_banned'] == 1) {  
                        $message = "This account has been banned.";  
                    } else {  
                        $_SESSION['user_id']  = $user['id'];  
                        $_SESSION['username'] = $user['username'];  
                        $_SESSION['email']    = $user['email'];  
                        $_SESSION['phone']    = $user['phone'];  
                        $success = "Login successful!";  
                    }  
                } else {  
                    $message = "Incorrect password.";  
                }  
            } else {  
                $message = "Account not found.";  
            }  
        } catch (PDOException $e) {  
            $message = "Database error: " . $e->getMessage();  
        }  
    }  
}  
?>  <!DOCTYPE html>  <html lang="en">  
<head>  
<meta charset="UTF-8">  
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">  
<title>Login</title>  
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">  <style>  
html, body {  
  height: 100%;  
  margin: 0;  
  padding: 0;  
}  
  
body {  
  display: flex;  
  flex-direction: column;  
  font-family: "Poppins", sans-serif;  
  background-color: #000;  
  color: #fff;  
}  
  
/* --- Header Image --- */  
.header {  
  width: 100%;  
  height: 220px;  
  background: url("back.jpg") center/cover no-repeat;  
  position: relative;  
}  
  
/* --- Header Icons --- */  
.header-icons {  
  position: absolute;  
  top: 20px;  
  right: 20px;  
  display: flex;  
  gap: 15px;  
  font-size: 22px;  
}  
.header-icons i {  
  color: #fff;  
  cursor: pointer;  
}  
  
/* --- Form Container --- */  
.container {  
  flex: 1;  
  background: #111;  
  border-radius: 25px 25px 0 0;  
  padding: 30px 25px 60px;  
  position: relative;  
  z-index: 2;  
  box-shadow: 0 -5px 12px rgba(0,0,0,0.4);  
  display: flex;  
  flex-direction: column;  
  justify-content: center; /* centers form vertically */  
}  
  
/* --- Tabs --- */  
.tabs {  
  display: flex;  
  justify-content: center;  
  gap: 40px;  
  margin-bottom: 25px;  
}  
.tab {  
  font-size: 16px;  
  color: #999;  
  cursor: pointer;  
  position: relative;  
}  
.tab.active {  
  color: #fff;  
  font-weight: 600;  
}  
.tab.active::after {  
  content: "";  
  position: absolute;  
  bottom: -5px;  
  left: 0;  
  right: 0;  
  height: 3px;  
  background: linear-gradient(to right, #ffddb3, #ffc685);  
  border-radius: 5px;  
}  
  
/* --- Input Boxes --- */  
.input-box {  
  width: 100%;  
  height: 40px;  
  background: #2a2a2a;  
  border: 1.5px solid #000;  
  border-radius: 10px;  
  padding: 0 10px;  
  font-size: 14px;  
  color: #fff;  
  box-shadow: 0 2px 6px rgba(255,255,255,0.1);  
  box-sizing: border-box;  
  margin-bottom: 15px;  
}  
.input-box::placeholder {  
  color: #ccc;  
}  
  
/* --- Remember & Forgot --- */  
.remember-forgot {  
  display: flex;  
  justify-content: space-between;  
  align-items: center;  
  margin-bottom: 15px;  
  font-size: 13px;  
}  
.remember-forgot label {  
  display: flex;  
  align-items: center;  
  gap: 8px;  
  color: #ccc;  
}  
.remember-forgot input {  
  width: 18px;  
  height: 18px;  
  accent-color: #f9b44c;  
}  
.remember-forgot a {  
  color: #f9b44c;  
  text-decoration: none;  
}  
  
/* --- Login Button --- */  
.login-btn {  
  width: 100%;  
  height: 40px;  
  border: none;  
  border-radius: 12px;  
  background: linear-gradient(to bottom, #F8D9A0, #FFF4D6);
  color: #111;  
  font-weight: 400;  
  font-size: 16px;  
  cursor: pointer;  
  margin-top: 5px;  
  transition: opacity 0.3s ease;  
}  
.login-btn:hover {  
  opacity: 0.9;  
}  
  
/* --- Divider --- */  
.divider {  
  display: flex;  
  align-items: center;  
  justify-content: center;  
  color: #777;  
  margin: 25px 0;  
  position: relative;  
}  
.divider::before,  
.divider::after {  
  content: "";  
  flex: 1;  
  height: 1px;  
  background: #333;  
  margin: 0 10px;  
}  
  
/* --- Register Button --- */  
.register-btn {  
  width: 100%;  
  height: 40px;  
  border: none;  
  border-radius: 12px;  
  background: blue;  
  color: white;  
  font-weight: 400;  
  font-size: 16px;  
  cursor: pointer;  
  transition: background 0.3s ease, opacity 0.3s ease;  
}  
.register-btn:hover {  
  background: #333;  
  opacity: 0.9;  
}  
  
/* --- Toast --- */  
.toast {  
  position: fixed;  
  top: 50%;  
  left: 50%;  
  transform: translate(-50%, -50%);  
  background: rgba(0,0,0,0.85);  
  color: #fff;  
  padding: 12px 20px;  
  border-radius: 10px;  
  font-size: 14px;  
  z-index: 2000;  
  display: none;  
}  
</style>  </head>  <body>  <div class="header">  
  <div class="header-icons">  
    <!-- Lock icon → Wallet Password -->  
    <a href="" title="Wallet Password">  
      <i class="fa-solid fa-lock"></i>  
    </a>  <!-- Mobile icon → Phone/Account Settings -->  
<a href="" title="Account Settings">  
  <i class="fa-solid fa-mobile-screen"></i>  
</a>  

<!-- Headphones icon → Online Support -->  
<a href="" title="Online Support">  
  <i class="fa-solid fa-headphones"></i>  
</a>  

<!-- Globe icon → Language Selector -->  
<a href="leng.php" title="Change Language">  
  <i class="fa-solid fa-globe"></i>  
</a>

  </div>  
</div>  <div class="container">  
  <div class="tabs">  
    <div class="tab active" id="tab-username">Username login</div>  
    <div class="tab" id="tab-email">Email login</div>  
  </div>    <form method="POST">  
    <input type="hidden" name="login_type" id="login_type" value="username">  
    <input type="text" name="login_value" class="input-box" placeholder="Username" required>  
    <input type="password" name="password" class="input-box" placeholder="Password" required>  <div class="remember-forgot">  
  <label><input type="checkbox"> Remember me</label>  
  <a href="#">Forgot password?</a>  
</div>  

<button type="submit" class="login-btn">Login</button>  

<div class="divider">or</div>  

<button type="button" class="register-btn" onclick="window.location='register.php'">Register</button>

  </form>  
</div>  <div class="toast" id="toast"></div>  <script>  
const tabUsername = document.getElementById('tab-username');  
const tabEmail = document.getElementById('tab-email');  
const inputBoxes = document.querySelectorAll('.input-box');  
const loginType = document.getElementById('login_type');  
  
tabUsername.addEventListener('click', () => {  
  tabUsername.classList.add('active');  
  tabEmail.classList.remove('active');  
  inputBoxes[0].placeholder = 'Username';  
  loginType.value = 'username';  
});  
  
tabEmail.addEventListener('click', () => {  
  tabEmail.classList.add('active');  
  tabUsername.classList.remove('active');  
  inputBoxes[0].placeholder = 'Email address';  
  loginType.value = 'email';  
});  
  
function showToast(message) {  
  const toast = document.getElementById("toast");  
  toast.innerText = message;  
  toast.style.display = "block";  
  setTimeout(() => { toast.style.display = "none"; }, 2500);  
}  
  
<?php if (!empty($message)): ?>  
showToast("<?= addslashes($message) ?>");  
<?php elseif (!empty($success)): ?>  
showToast("<?= addslashes($success) ?>");  
setTimeout(() => { window.location.href = 'dashboard.php'; }, 2000);  
<?php endif; ?>  
</script>  </body>  
</html>  
