<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Handle language change
if (isset($_GET['setlang'])) {
    $_SESSION['lang'] = $_GET['setlang'];
    $_SESSION['lang_changed'] = true;

    // Return to previous page or home
    $prev = $_SERVER['HTTP_REFERER'] ?? 'home.php';
    header("Location: $prev");
    exit;
}

$currentLang = $_SESSION['lang'] ?? 'en';
$languages = [
    'en' => 'English',
    'es' => 'Español',
    'fr' => 'Français',
    'de' => 'Deutsch',
    'ar' => 'العربية',
    'ru' => 'Русский',
    'it' => 'Italiano',
    'ro' => 'Română',
    'id' => 'Bahasa Indonesia',
    'pl' => 'Polski'
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Select Language</title>
<style>
body {
  margin: 0;
  font-family: "Poppins", sans-serif;
  background: #000;
  color: #fff;
}
.container {
  padding: 20px;
  max-width: 400px;
  margin: 40px auto;
  background: #111;
  border-radius: 20px;
  box-shadow: 0 0 15px rgba(255,255,255,0.1);
}
h2 {
  text-align: center;
  color: #f5f5f5;
  margin-bottom: 20px;
}
.lang-list {
  list-style: none;
  padding: 0;
  margin: 0;
}
.lang-list li {
  padding: 15px 18px;
  margin: 8px 0;
  background: #1b1b1b;
  border-radius: 10px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  cursor: pointer;
  transition: background 0.3s;
}
.lang-list li:hover {
  background: #333;
}
.active {
  border: 1px solid #ff4444;
}
.checkmark {
  color: #ff4444;
  font-weight: bold;
}
.toast {
  position: fixed;
  bottom: 25px;
  left: 50%;
  transform: translateX(-50%);
  background: rgba(255,255,255,0.1);
  padding: 10px 18px;
  border-radius: 8px;
  color: #fff;
  display: none;
  opacity: 0;
  transition: opacity 0.5s;
}
.toast.show {
  display: block;
  opacity: 1;
}
</style>
</head>
<body>
<div class="container">
  <h2>Select Language</h2>
  <ul class="lang-list">
    <?php foreach ($languages as $code => $name): ?>
      <li class="<?= ($currentLang == $code) ? 'active' : ''; ?>"
          onclick="changeLang('<?= $code; ?>')">
        <span><?= $name; ?></span>
        <?php if ($currentLang == $code): ?><span class="checkmark">✔</span><?php endif; ?>
      </li>
    <?php endforeach; ?>
  </ul>
</div>

<div class="toast" id="toast">Language changed!</div>

<script>
// Function to change language
function changeLang(code) {
  window.location = '?setlang=' + code;
}

// Show toast if language was changed
<?php if (!empty($_SESSION['lang_changed'])): ?>
const toast = document.getElementById('toast');
toast.classList.add('show');
setTimeout(() => {
  toast.classList.remove('show');
}, 2000);
<?php unset($_SESSION['lang_changed']); ?>
<?php endif; ?>
</script>
</body>
</html>