<?php  
session_start();  

// Handle language change  
if (isset($_GET['lang'])) {  
    $_SESSION['lang'] = $_GET['lang'];  
    header("Location: dashboard.php"); // Go directly to dashboard  
    exit;  
}  

// Current language (default: English)  
$lang = $_SESSION['lang'] ?? 'en';  

// Available languages list (extended)  
$languages = [  
    'en' => 'English',  
    'fr' => 'Français',  
    'es' => 'Español',  
    'de' => 'Deutsch',  
    'ar' => 'العربية',  
    'pt' => 'Português',  
    'it' => 'Italiano',  
    'ru' => 'Русский',  
    'zh' => '中文 (简体)',  
    'ja' => '日本語',  
    'ko' => '한국어',  
    'hi' => 'हिन्दी',  
    'tr' => 'Türkçe',  
    'sw' => 'Kiswahili',  
];  
?>  

<!DOCTYPE html>  
<html lang="<?= $lang ?>">  
<head>  
  <meta charset="UTF-8">  
  <title>Switch Language</title>  
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">  
  <script src="https://cdn.tailwindcss.com"></script>  
</head>  
<body class="bg-black text-white min-h-screen flex flex-col">  

  <!-- Header -->  
  <div class="bg-[#caa076] text-black font-bold py-3 px-4 flex items-center">  
    <a href="dashboard.php" class="mr-3">⬅</a>  
    <span>Switch Language</span>  
  </div>  

  <!-- Language list -->  
  <div class="flex-1 overflow-y-auto p-4">  
    <ul class="space-y-3">  
      <?php foreach ($languages as $code => $name): ?>  
        <li>  
          <a href="?lang=<?= $code ?>"  
             class="flex items-center justify-between px-4 py-3 rounded-lg   
                    <?= ($lang === $code ? 'bg-[#caa076] text-black font-semibold' : 'bg-gray-900 text-white hover:bg-[#caa076] hover:text-black') ?>">  
            <span><?= $name ?></span>  
            <?php if ($lang === $code): ?> ✅ <?php endif; ?>  
          </a>  
        </li>  
      <?php endforeach; ?>  
    </ul>  
  </div>  

</body>  
</html>