<?php
session_start();
if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

include 'db.php';
$phone = $_SESSION['phone'];

// Fetch invite code
$stmt = $conn->prepare("SELECT invite_code FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$inviteCode = $user['invite_code'] ?? 'N/A';

// Build full referral link
$referralLink = "https://new-line-cinema.cc/user/reg?inviteCode=" . urlencode($inviteCode);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Promotion QR Code</title>
  <style>
    body {
      margin: 0;
      background-color: #000;
      color: #fff;
      font-family: 'Poppins', Arial, sans-serif;
    }
    .container {
      max-width: 420px;
      margin: 0 auto;
      padding: 20px;
      text-align: center;
    }
    .title {
      font-size: 20px;
      font-weight: bold;
      margin-bottom: 10px;
    }
    .link-box {
      background-color: #111;
      border: 1px solid #333;
      border-radius: 8px;
      padding: 10px;
      color: #bbb;
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-size: 14px;
      margin-bottom: 20px;
      overflow-x: auto;
    }
    .link-box button {
      background: transparent;
      border: none;
      color: #00ff00;
      font-size: 18px;
      cursor: pointer;
    }
    .promo-image {
      background: linear-gradient(180deg, #0f0f0f, #001900);
      border-radius: 12px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 255, 0, 0.2);
      margin-bottom: 20px;
    }
    .promo-image img {
      width: 100%;
      border-radius: 12px;
    }
    .invite-box {
      background: #111;
      border-radius: 12px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px;
      border: 1px solid #222;
      margin-bottom: 20px;
    }
    .invite-text {
      text-align: left;
    }
    .invite-text .name {
      font-weight: bold;
      font-size: 16px;
    }
    .invite-text .code {
      font-size: 14px;
      color: #00ff00;
    }
    .qr-box img {
      width: 60px;
      height: 60px;
      border-radius: 8px;
    }
    .btn-row {
      display: flex;
      gap: 10px;
    }
    .btn {
      flex: 1;
      padding: 12px;
      border-radius: 8px;
      border: none;
      font-size: 15px;
      cursor: pointer;
      font-weight: 500;
    }
    .copy-btn {
      background: transparent;
      border: 1px solid #00ff00;
      color: #00ff00;
    }
    .save-btn {
      background: #00ff00;
      color: #000;
    }
    #popup {
      display: none;
      position: fixed;
      bottom: 25px;
      right: 25px;
      background-color: #111;
      border: 1px solid #00ff00;
      color: #00ff00;
      padding: 8px 15px;
      border-radius: 8px;
      font-size: 14px;
      box-shadow: 0 0 15px rgba(0,255,0,0.5);
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="title">Promotion QR Code</div>

    <div class="link-box">
      <span id="inviteLink"><?= htmlspecialchars($referralLink) ?></span>
      <button onclick="copyLink()">📋</button>
    </div>

    <div class="promo-image">
      <img src="https://i.ibb.co/m4k3zY8/cero-promo.jpg" alt="Promotion Banner">
      <div style="margin-top:10px; font-size:18px; color:#00ff00;">Watch videos and earn money</div>
      <div style="font-size:14px; color:#aaa;">Leisure and earning money</div>
    </div>

    <div class="invite-box">
      <div class="invite-text">
        <div class="name">Grow your team, grow your income!</div>
        <div class="code">Invitation Code: <?= htmlspecialchars($inviteCode) ?></div>
      </div>
      <div class="qr-box">
        <img src="https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=<?= urlencode($referralLink) ?>" alt="QR Code">
      </div>
    </div>

    <div class="btn-row">
      <button class="btn copy-btn" onclick="copyLink()">Copy Invite Link</button>
      <button class="btn save-btn" onclick="saveQR()">Save QR code</button>
    </div>
  </div>

  <div id="popup">Link copied!</div>

  <script>
    function copyLink() {
      const text = document.getElementById('inviteLink').innerText;
      navigator.clipboard.writeText(text).then(() => {
        const popup = document.getElementById('popup');
        popup.style.display = 'block';
        setTimeout(() => popup.style.display = 'none', 2000);
      });
    }

    function saveQR() {
      const qrURL = "https://api.qrserver.com/v1/create-qr-code/?size=400x400&data=<?= urlencode($referralLink) ?>";
      const link = document.createElement('a');
      link.href = qrURL;
      link.download = "Invite_QR_<?= htmlspecialchars($inviteCode) ?>.png";
      link.click();
    }
  </script>
</body>
</html>