<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
  header("Location: login.php");
  exit();
}

$phone = $_SESSION['phone'];

// Fetch funds to be released
$stmt = $conn->prepare("SELECT funds_to_be_released FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$funds_to_be_released = isset($user['funds_to_be_released']) ? (float)$user['funds_to_be_released'] : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Funds to be released</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      background-color: #000;
      color: #fff;
      font-family: 'Inter', sans-serif;
    }
    .gradient-box {
      background: linear-gradient(to bottom, #fff3cf, #f7ca77);
      border-radius: 14px;
      padding: 1.5rem;
      text-align: center;
      color: #000;
      box-shadow: 0 2px 6px rgba(0,0,0,0.3);
    }
    .icon-section {
      background: #1a1a1a;
      border-radius: 14px;
      padding: 1rem;
      display: flex;
      justify-content: space-around;
      text-align: center;
    }
    .icon-section div {
      width: 80px;
    }
    .icon-section img {
      width: 45px;
      height: 45px;
      margin: 0 auto 0.5rem;
    }
  </style>
</head>
<body class="min-h-screen flex flex-col">
  <!-- Header -->
  <div class="flex items-center justify-center px-4 py-3 border-b border-gray-800 relative">
    <button onclick="history.back()" class="absolute left-4 text-xl">
      <i class="fa-solid fa-arrow-left"></i>
    </button>
    <h1 class="text-lg font-semibold">Funds to be released</h1>
  </div>

  <!-- Funds to be Released Box -->
  <div class="mx-4 mt-4">
    <div class="gradient-box">
      <div class="text-sm font-medium">Funds to be released (USDT)</div>
      <div class="text-5xl font-bold mt-2"><?= number_format($funds_to_be_released, 2) ?></div>
    </div>
  </div>

  <!-- Description -->
  <div class="text-center text-sm text-gray-300 mt-6 mb-3">
    Description of funds to be released
  </div>

  <!-- Burn / Friendship / Release -->
  <div class="mx-4 icon-section">
    <div>
      <img src="icons/burn.png" alt="Burn">
      <div class="font-semibold text-sm">Burn</div>
      <div class="text-xs text-gray-400 mt-1">Invitation rewards lower than the friend portion will cause burn</div>
    </div>
    <div>
      <img src="icons/burn.png" alt="Friendship">
      <div class="font-semibold text-sm">Friendship<br>Level</div>
    </div>
    <div>
      <img src="icons/transfer.jpg" alt="Release">
      <div class="font-semibold text-sm">Release</div>
      <div class="text-xs text-gray-400 mt-1">Equal or higher than the amount that can be released by friends</div>
    </div>
  </div>

  <!-- Info Section -->
  <div class="px-5 mt-6 space-y-4 text-sm text-gray-300 leading-relaxed">
    <div>
      <span class="text-yellow-400 font-semibold">🔥 Funds to be released:</span><br>
      When team members subscribe to a package level higher than themselves, this value will appear.
    </div>
    <div>
      <span class="text-yellow-400 font-semibold">💰 How to release funds:</span><br>
      1. Upgrade your package level to the same level as your team members within 7 days.<br>
      2. If you do not upgrade within 7 days, the fund release opportunity will disappear.
    </div>
  </div>

  <div class="h-20"></div> <!-- Bottom spacing -->
</body>
</html>