
<?php  
$pageTitle = "Member Center";  
ini_set('display_errors', 1);  
ini_set('display_startup_errors', 1);  
error_reporting(E_ALL);  
  
if (session_status() === PHP_SESSION_NONE) session_start();  
include 'db.php';  
  
if (!isset($_SESSION['phone'])) {  
    header("Location: login.php");  
    exit;  
}  
  
$phone = $_SESSION['phone'];  
  
// Fetch current user  
$stmt = $conn->prepare("SELECT * FROM users WHERE phone = ?");  
$stmt->execute([$phone]);  
$user = $stmt->fetch(PDO::FETCH_ASSOC);  
$user_id = $user['id'] ?? 0;  
  
// Set your target timezone (example: Nigeria)  
$tz = new DateTimeZone('Africa/Lagos');  // or your real local timezone  
  
// 🔹 Count direct downlines (Level 1 referrals)  
// Count ONLY active downlines (those who purchased at least one VIP)  
$stmt = $conn->prepare("  
    SELECT COUNT(DISTINCT u.id)  
    FROM users u  
    JOIN purchases p ON p.user_id = u.id  
    WHERE u.invited_by = ?  
");  
$stmt->execute([$user['invite_code']]);  
$downline_count = (int)$stmt->fetchColumn();  
  
  
  
  
$now       = new DateTime('now', $tz);  
$resetTime = new DateTime('today 3:00:00', $tz);  
  
// If current time is before 3AM, use yesterday's 3AM  
if ($now < $resetTime) {  
    $resetTime->modify('-1 day');  
}  
  
  
$last_task_reset = $user['last_task_reset'] ?? null;  
  
// If never reset, or last reset is before the last reset checkpoint → reset  
if (empty($last_task_reset) || strtotime($last_task_reset) < $resetTime->getTimestamp()) {  
    // Reset task status  
    $stmt = $conn->prepare("UPDATE task_records SET scored_today = 0 WHERE user_id = ?");  
    $stmt->execute([$user_id]);  
  
    // Countdown logic...  
    $stmt = $conn->prepare("  
        UPDATE purchases p  
        LEFT JOIN (  
            SELECT vip_product_id  
            FROM task_records  
            WHERE user_id = ? AND DATE(scored_at) = CURDATE()  
        ) t ON p.vip_product_id = t.vip_product_id  
        SET p.expire_at = DATE_SUB(p.expire_at, INTERVAL 1 DAY)  
        WHERE p.user_id = ?  
          AND p.expire_at > NOW()  
          AND t.vip_product_id IS NULL  
    ");  
    $stmt->execute([$user_id, $user_id]);  
  
    $stmt = $conn->prepare("UPDATE users SET last_task_reset = NOW() WHERE id = ?");  
    $stmt->execute([$user_id]);  
}  
  
/* ------------------ Release Matured Funds ------------------ */  
$stmt = $conn->prepare("SELECT * FROM funds_to_be_released WHERE user_id = ? AND created_at <= DATE_SUB(NOW(), INTERVAL 7 DAY)");  
$stmt->execute([$user_id]);  
$maturedFunds = $stmt->fetchAll(PDO::FETCH_ASSOC);  
  
foreach ($maturedFunds as $fund) {  
    if ($fund['type'] === 'Flexible Wallet') {  
        $stmt2 = $conn->prepare("UPDATE users SET flexible_wallet = flexible_wallet + ? WHERE id = ?");  
        $stmt2->execute([$fund['amount'], $fund['user_id']]);  
    } elseif ($fund['type'] === 'NLC Points') {  
        $stmt2 = $conn->prepare("UPDATE users SET nlc_points = nlc_points + ? WHERE id = ?");  
        $stmt2->execute([$fund['amount'], $fund['user_id']]);  
    }  
    $stmt2 = $conn->prepare("DELETE FROM funds_to_be_released WHERE id = ?");  
    $stmt2->execute([$fund['id']]);  
}  
  
/* ------------------ Calculate Today's Earnings ------------------ */  
// Task earnings  
$stmt = $conn->prepare("SELECT SUM(amount)   
                        FROM task_records   
                        WHERE user_id = ?   
                          AND DATE(scored_at) = CURDATE()");  
$stmt->execute([$user_id]);  
$taskEarnings = (float)($stmt->fetchColumn() ?? 0);  
  
// Rebates  
$stmt = $conn->prepare("SELECT COALESCE(SUM(amount),0)   
                        FROM rebates   
                        WHERE user_id = ?   
                          AND DATE(created_at) = CURDATE()");  
$stmt->execute([$user_id]);  
$rebateEarnings = (float)$stmt->fetchColumn();  
  
// Referral rewards  
$stmt = $conn->prepare("SELECT COALESCE(SUM(amount),0)   
                        FROM referral_bonus   
                        WHERE user_id = ?   
                          AND DATE(created_at) = CURDATE()");  
$stmt->execute([$user_id]);  
$referralEarnings = (float)$stmt->fetchColumn();  
  
$today_earnings = $taskEarnings + $rebateEarnings + $referralEarnings;  
  
/* ------------------ Funds to Be Released ------------------ */  
$stmtFTR = $conn->prepare("SELECT COALESCE(SUM(amount),0)   
                           FROM funds_to_be_released   
                           WHERE user_id = ? AND type='Flexible Wallet'");  
$stmtFTR->execute([$user_id]);  
$funds_to_be_released = (float)$stmtFTR->fetchColumn();  
  
/* ------------------ Handle VIP Purchase ------------------ */  
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['vip_id'], $_POST['txn_password'])) {  
    header('Content-Type: application/json');  
    $vip_id = (int)$_POST['vip_id'];  
    $txn_password = $_POST['txn_password'];  
  
    // Fetch VIP product  
    $stmt = $conn->prepare("SELECT * FROM vip_products WHERE id = ?");  
    $stmt->execute([$vip_id]);  
    $vip = $stmt->fetch(PDO::FETCH_ASSOC);  
    if (!$vip) {  
        echo json_encode(['status'=>'error','message'=>'VIP product not found.']);  
        exit;  
    }  
  
    $balance = (float)($user['electronic_wallet'] ?? 0);  
    $vipAmount = (float)($vip['amount'] ?? 0);  
  
    // Step 1: Check funds  
if ($balance < $vipAmount) {  
    echo json_encode(['status'=>'insufficient','message'=>'Insufficient balance']);  
    exit;  
}  
  
// ❌ Removed restriction rule for VIP3 (no referral requirement)  
  
  
    // Step 3: Deduct balance & save purchase  
    $new_balance = $balance - $vipAmount;  
    $stmt = $conn->prepare("UPDATE users SET electronic_wallet = ? WHERE id = ?");  
    $stmt->execute([$new_balance, $user_id]);  
  
    // Expiry (3AM rule)  
$valid_days = (int)$vip['valid_days'];  
$now = new DateTime();  
$today3am = new DateTime('today 3:00:00');  
  
// Always count from the NEXT 3AM  
if ($now < $today3am) {  
    // Before today's 3AM → start from today 3AM  
    $start = clone $today3am;  
} else {  
    // After today's 3AM → start from tomorrow 3AM  
    $start = (clone $today3am)->modify('+1 day');  
}  
  
// Expire after valid_days cycles  
$expire_at = (clone $start)->modify("+{$valid_days} days");  
  
    $stmt = $conn->prepare("  
        INSERT INTO purchases (user_id, vip_product_id, amount, purchased_at, expire_at)  
        VALUES (?, ?, ?, NOW(), ?)  
    ");  
    $stmt->execute([$user_id, $vip_id, $vipAmount, $expire_at->format('Y-m-d H:i:s')]);  
      
    /* ------------------ Release Locked Funds (when upline upgrades) ------------------ */  
$stmtVIP = $conn->prepare("  
    SELECT MAX(vp.amount)  
    FROM purchases p  
    JOIN vip_products vp ON vp.id = p.vip_product_id  
    WHERE p.user_id = ?  
");  
$stmtVIP->execute([$user_id]);  
$currentMaxVIP = (float)$stmtVIP->fetchColumn();  
  
$stmtFunds = $conn->prepare("  
    SELECT ftr.*   
    FROM funds_to_be_released ftr  
    JOIN vip_products vp ON ftr.vip_product_id = vp.id  
    WHERE ftr.user_id = ? AND vp.amount <= ?  
");  
$stmtFunds->execute([$user_id, $currentMaxVIP]);  
$pendingFunds = $stmtFunds->fetchAll(PDO::FETCH_ASSOC);  
  
foreach ($pendingFunds as $fund) {  
    // Pay to upline's flexible wallet  
    $stmt = $conn->prepare("UPDATE users SET flexible_wallet = flexible_wallet + ? WHERE id = ?");  
    $stmt->execute([$fund['amount'], $user_id]);  
  
    // Record bonus  
    $stmt = $conn->prepare("INSERT INTO referral_bonus (user_id, amount, created_at) VALUES (?, ?, NOW())");  
    $stmt->execute([$user_id, $fund['amount']]);  
  
    // Remove from locked funds  
    $stmt = $conn->prepare("DELETE FROM funds_to_be_released WHERE id = ?");  
    $stmt->execute([$fund['id']]);  
}  
  
    // Step 4: NLC distribution (if VIP ≥ 30)
$fixed_points = [6, 4, 1];
$current_user_id = $user_id;

if ($vipAmount >= 30) {
    for ($level = 0; $level < 3; $level++) {
        // Find upline by invite code
        $stmt = $conn->prepare("SELECT invited_by FROM users WHERE id = ?");
        $stmt->execute([$current_user_id]);
        $invited_by_code = $stmt->fetchColumn();
        if (!$invited_by_code) break;

        // Get upline info
        $stmt = $conn->prepare("SELECT id, nlc_points FROM users WHERE invite_code = ?");
        $stmt->execute([$invited_by_code]);
        $upline = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$upline) break;

        // Check upline VIP level
        $stmtVIP = $conn->prepare("
            SELECT MAX(vp.amount)
            FROM purchases p
            JOIN vip_products vp ON vp.id = p.vip_product_id
            WHERE p.user_id = ?
        ");
        $stmtVIP->execute([$upline['id']]);
        $uplineMaxVIP = (float)$stmtVIP->fetchColumn();

        // If upline also has VIP ≥ 30, give points
        if ($uplineMaxVIP >= 30) {
            $points = $fixed_points[$level];
            $new_nlc = ((int)$upline['nlc_points']) + $points;

            // Update upline total NLC points
            $stmt2 = $conn->prepare("UPDATE users SET nlc_points = ? WHERE id = ?");
            $stmt2->execute([$new_nlc, $upline['id']]);

            // Record this specific earning in nlc_points_record
            $stmt3 = $conn->prepare("
                INSERT INTO nlc_points_record 
                (user_id, from_user_id, vip_product_id, points, level, created_at)
                VALUES (?, ?, ?, ?, ?, NOW())
            ");
            $stmt3->execute([
                $upline['id'],   // who received the NLC
                $user_id,        // who triggered the earning
                $vip_id,         // VIP product purchased
                $points,         // how many points earned
                $level + 1       // level (1, 2, 3)
            ]);
        }

        $current_user_id = $upline['id']; // move up the chain
    }
}

      
// Step 5: Referral bonus & locked funds  
    if (!empty($user['invited_by']) && !empty($vip['referral_bonus'])) {  
        $stmt = $conn->prepare("SELECT * FROM users WHERE invite_code = ?");  
        $stmt->execute([$user['invited_by']]);  
        $inviter = $stmt->fetch(PDO::FETCH_ASSOC);  
  
        if ($inviter) {  
            $inviterId = (int)$inviter['id'];  
            $bonusAmount = (float)$vip['referral_bonus'];  
  
            // ✅ Get inviter's current max VIP  
            $stmtVIP = $conn->prepare("  
                SELECT MAX(vp.amount)  
                FROM purchases p  
                JOIN vip_products vp ON p.vip_product_id = vp.id  
                WHERE p.user_id = ?  
            ");  
            $stmtVIP->execute([$inviterId]);  
            $inviterMaxVIP = (float)$stmtVIP->fetchColumn();  
  
            if ($vipAmount > $inviterMaxVIP) {  
                // Downline bought higher VIP → lock the funds  
                $stmt = $conn->prepare("  
                    INSERT INTO funds_to_be_released (user_id, from_user_id, vip_product_id, amount, type, created_at, expire_at)  
                    VALUES (?, ?, ?, ?, 'Flexible Wallet', NOW(), DATE_ADD(NOW(), INTERVAL 10 DAY))  
                ");  
                $stmt->execute([$inviterId, $user_id, $vip_id, $bonusAmount]);  
            } else {  
                // Upline already same/higher VIP → pay directly  
                $stmt = $conn->prepare("UPDATE users SET flexible_wallet = flexible_wallet + ? WHERE id = ?");  
                $stmt->execute([$bonusAmount, $inviterId]);  
                $stmt = $conn->prepare("INSERT INTO referral_bonus (user_id, amount, created_at) VALUES (?, ?, NOW())");  
                $stmt->execute([$inviterId, $bonusAmount]);  
            }  
  
            // ✅ Release all pending funds if inviter is now eligible  
            $stmtFunds = $conn->prepare("  
                SELECT ftr.*   
                FROM funds_to_be_released ftr  
                JOIN vip_products vp ON ftr.vip_product_id = vp.id  
                WHERE ftr.user_id = ? AND vp.amount <= ?  
            ");  
            $stmtFunds->execute([$inviterId, $inviterMaxVIP]);  
            $pendingFunds = $stmtFunds->fetchAll(PDO::FETCH_ASSOC);  
  
            foreach ($pendingFunds as $fund) {  
                $stmt = $conn->prepare("UPDATE users SET flexible_wallet = flexible_wallet + ? WHERE id = ?");  
                $stmt->execute([$fund['amount'], $inviterId]);  
  
                $stmt = $conn->prepare("INSERT INTO referral_bonus (user_id, amount, created_at) VALUES (?, ?, NOW())");  
                $stmt->execute([$inviterId, $fund['amount']]);  
  
                $stmt = $conn->prepare("DELETE FROM funds_to_be_released WHERE id = ?");  
                $stmt->execute([$fund['id']]);  
            }  
  
            // Cleanup expired locked funds  
            $stmt = $conn->prepare("DELETE FROM funds_to_be_released WHERE expire_at < NOW()");  
            $stmt->execute();  
        }  
    }  
      
  
    echo json_encode(['status'=>'success','message'=>'VIP purchase successful!']);  
    exit;  
}  
  
/* ------------------ Fetch All VIP Products ------------------ */  
$stmt = $conn->prepare("SELECT * FROM vip_products ORDER BY (name='VIP 0') DESC, amount ASC");  
$stmt->execute();  
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);  
?>  

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, minimal-ui" />
<meta name="format-detection" content="telephone=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<meta name="apple-touch-fullscreen" content="yes" />
<title>Member Center</title>

<style>
  /* ===================== Existing Styles ===================== */
  body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background-color: #000;
    color: #fff;
  }
  .header {
    background-color:#111;
    color:#fff;
    text-align:center;
    font-weight:600;
    font-size:18px;
    padding:14px 0;
    border-bottom:1px solid #333;
    position:relative;
  }
  .team-icon {
    position:absolute;
    right:14px;
    top:50%;
    transform:translateY(-50%);
    width:22px;
    height:22px;
    cursor:pointer;
    transition:0.3s ease;
  }
  .team-icon:hover {
    transform: translateY(-50%) scale(1.1);
    filter: drop-shadow(0 0 4px rgba(248,217,160,0.6));
  }
  .summary-container {
    text-align:center;
    margin:15px;
    padding:10px;
    background: rgba(255,255,255,0.05);
    border:1px solid rgba(248,217,160,0.3);
    border-radius:12px;
    box-shadow:0 0 12px rgba(248,217,160,0.2);
    backdrop-filter:blur(6px);
    transition:0.3s ease-in-out;
    min-height:50px;
  }
  .description-wrapper { text-align:left; margin:10px 0 4px 0; }
  .description-btn {
    background: linear-gradient(180deg,#F8D9A0 0%,#FFD580 100%);
    color:#000;
    font-weight:600;
    font-size:13px;
    border:none;
    border-radius:20px;
    padding:6px 16px;
    cursor:pointer;
    transition:all 0.3s ease;
  }
  .summary-card {
    background: linear-gradient(180deg,#F8D9A0 0%,#FFF4D6 100%);
    color:#000;
    border-radius:12px;
    padding:20px 10px;
    text-align:center;
    font-weight:500;
  }
  .summary-card .row { display:flex; justify-content:space-around; align-items:center; }
  .summary-card .value { font-size:14px; font-weight:700; margin-bottom:3px; }
  .section-title {
    color:#F8D9A0;
    font-size:15px;
    font-weight:bold;
    text-align:center;
    margin:18px 0 10px 0;
    position:relative;
  }
  .section-title::before, .section-title::after { content:'✨'; position:relative; margin:0 8px; }
  .package-info-swapped { display:flex; justify-content:space-between; text-align:center; margin:10px 0; }
  .package-item { flex:1; display:flex; flex-direction:column; align-items:center; }
  .package-item .value { font-weight:800; font-size:16px; color:#fff; margin-bottom:4px; }
  .package-item .label { font-weight:600; font-size:13px; color:#F8D9A0; text-shadow:0 0 4px rgba(248,217,160,0.6); }
  .package-card {
    background:rgba(0,0,0,0.3);
    border:1px solid rgba(248,217,160,0.4);
    border-radius:16px;
    padding:12px 16px;
    margin:10px 16px;
    box-shadow:0 0 18px rgba(248,217,160,0.35);
    backdrop-filter:blur(8px);
    transition:0.3s ease-in-out;
  }
  .package-title {
    font-weight:700;
    font-size:13px;
    color:#F8D9A0;
    text-shadow:0 0 6px rgba(248,217,160,0.6);
  }
  
  .package-item .label {
  font-weight: 600;
  font-size: 11px;
  color: silver;
  text-shadow: 0 0 4px rgba(248,217,160,0.6);
}
  .title-divider {
    width:50%;
    height:2px;
    background:linear-gradient(90deg, rgba(248,217,160,0.8), rgba(248,217,160,0.2));
    margin:6px 0 10px 0;
    border-radius:2px;
  }
  .unlock-btn {
    background:linear-gradient(180deg,#F8D9A0 0%,#FFF4D6 100%);
    color:#000;
    border:none;
    border-radius:20px;
    padding:8px 16px;
    font-weight:600;
    cursor:pointer;
    transition:0.3s ease;
    width:100%;
  }
  .unlock-btn.completed { background:linear-gradient(180deg,#ff9800 0%,#ffc107 100%); color:#fff; }
  #toast {
    position:fixed;
    bottom:80px;
    left:50%;
    transform:translateX(-50%);
    background-color:rgba(0,0,0,0.85);
    color:#fff;
    padding:14px 18px;
    border-radius:20px;
    font-size:13px;
    display:none;
    z-index:9999;
  }
  .modal { display:none; position:fixed; z-index:10000; left:0; top:0; width:100%; height:100%; background-color:rgba(0,0,0,0.7); backdrop-filter:blur(3px); justify-content:center; align-items:center; }
  .modal-content {
    background-color:#111;
    border:1px solid rgba(248,217,160,0.4);
    color:#fff;
    padding:20px;
    border-radius:12px;
    width:85%;
    max-width:360px;
    box-shadow:0 0 20px rgba(248,217,160,0.3);
  }
  .close-btn { color:#F8D9A0; float:right; font-size:20px; font-weight:bold; cursor:pointer; }
</style>

<script>
  // ===================== Disable zoom =====================
  document.addEventListener('touchstart', function(event) {
    if (event.touches.length > 1) event.preventDefault(); // pinch zoom
  }, { passive: false });

  let lastTouchEnd = 0;
  document.addEventListener('touchend', function(event) {
    const now = (new Date()).getTime();
    if (now - lastTouchEnd <= 300) event.preventDefault(); // double-tap zoom
    lastTouchEnd = now;
  }, false);

  document.addEventListener('gesturestart', function (e) {
    e.preventDefault(); // iOS gesture zoom
  });
</script>

</head>
<body>





<div id="toast"></div>
<div class="header">
  Member Center
  <a href="task_record"><img src="images/membership.png" alt="Team List" class="team-icon"></a>
</div>

<div class="summary-container">
  <div class="description-wrapper">
    <button class="description-btn" id="tapDescription">Description</button>
  </div>
  <div class="summary-card">
    <div class="row">
      <div>
        <div class="value"><?= number_format($today_earnings, 2) ?></div>
        <div class="label">Today Earning (USDT)</div>
      </div>
      <div>
        <div class="value"><?= number_format($funds_to_be_released, 2) ?></div>
        <div class="label">Cumulative Earning (USDT)</div>
      </div>
    </div>
  </div>
</div>

<div class="section-title">Special Package</div>

<?php foreach ($products as $product): 
  $vip = (int)$product['id']; 
  $title = htmlspecialchars($product['name']); 
  $amt = number_format($product['amount'], 2) . " USDT"; 
?>
<div class="package-card" id="card-<?= $vip ?>">
  <div class="package-header">
    <span class="package-title"><?= $title ?></span>
  </div>
  <div class="title-divider"></div>
  <div class="package-info-swapped">
    <div class="package-item">
      <div class="value"><?= $product['daily_earning_limit'] ?> View</div>
      <div class="label">Daily Per View</div>
    </div>
    <div class="package-item">
      <!-- ✅ Added days span for JS -->
      <div class="value" id="days-<?= $vip ?>"><?= $product['valid_days'] ?> Days</div>
      <div class="label">Valid Time</div>
    </div>
    <div class="package-item">
      <div class="value"><?= number_format($product['viewing_income'], 1) ?> USDT</div>
      <div class="label">Per View Income</div>
    </div>
  </div>

  <?php
  $isLocked = false;
  $lockReason = '';
  if ($product['amount'] >= 300) { $isLocked = true; $lockReason = '🔐 (Locked)'; }
  if ($product['amount'] == 200 && $downline_count < 2) { $isLocked = true; $lockReason = ''; }
  ?>
  <?php if ($isLocked): ?>
    <button class="unlock-btn" id="btn-<?= $vip ?>" disabled style="cursor:not-allowed;"><?= $amt ?> <?= $lockReason ?></button>
  <?php else: ?>
    <button class="unlock-btn" id="btn-<?= $vip ?>"><?= $amt ?> Unlock Now</button>
  <?php endif; ?>
</div>
<?php endforeach; ?>

<!-- Modal -->
<div id="infoModal" class="modal">
  <div class="modal-content">
    <span class="close-btn" id="closeModal">&times;</span>
    <h3 style="color:#F8D9A0;">Earning Summary</h3>
    <p style="font-size:14px;line-height:1.5;margin-top:10px;">
      This section shows your <b>Today’s Earning</b> and <b>Cumulative Earnings</b> in USDT.
      It gives you an overview of your total income performance.
      Earnings are automatically updated based on your daily activity and package level.
    </p>
  </div>
</div>

<script>
function showToast(msg) {
  const t = document.getElementById('toast');
  t.innerText = msg;
  t.style.display = 'block';
  setTimeout(() => { t.style.display = 'none'; }, 2000);
}

window.addEventListener('pageshow', function(event) {
  if (event.persisted || performance.getEntriesByType("navigation")[0].type === "back_forward") {
    window.location.reload();
  }
});

document.addEventListener('DOMContentLoaded', () => {
  // ✅ Save original text and assign purchaseVIP onclick
  document.querySelectorAll('.unlock-btn').forEach(btn => {
    btn.dataset.originalText = btn.dataset.originalText || btn.textContent;
    const vipId = parseInt(btn.id.replace('btn-', ''), 10);
    if (!btn.disabled) btn.onclick = () => purchaseVIP(vipId);
  });

  // ✅ Fetch task status
  fetch('get_task_status.php')
    .then(res => res.json())
    .then(data => {
      const updatedVIPs = [];

      data.forEach(item => {
        const btn = document.getElementById('btn-' + item.vip_id);
        const daysElement = document.getElementById('days-' + item.vip_id);
        if (!btn || !daysElement) return;

        updatedVIPs.push(item.vip_id);

        const remaining = parseInt(item.remaining_days, 10);
        daysElement.textContent = `${remaining} Day${remaining !== 1 ? 's' : ''}`;
        daysElement.style.color = '#FFD700';

        // 🔹 If the package has lapsed (expired)
        if (remaining <= 0) {
          btn.disabled = true;
          btn.classList.add('completed');
          btn.textContent = 'The earning lapsed today';
          btn.style.background = 'linear-gradient(180deg,#555 0%,#333 100%)';
          btn.style.color = '#aaa';
          btn.style.cursor = 'not-allowed';
          btn.onclick = null;
          return;
        }

        // 🔹 If completed for today
        if (item.completed >= item.total) {
          btn.disabled = true;
          btn.classList.add('completed');
          btn.textContent = `Completed for today ✅`;
          btn.onclick = null;
        } else {
          // 🔹 Active and available for use
          btn.disabled = false;
          btn.classList.remove('completed');
          btn.textContent = `Task Progress: ${item.completed}/${item.total}`;
          btn.onclick = () => window.location.href = 'task_vip.php?vip=' + item.vip_id;
        }
      });

      // Restore non-updated buttons to default state
      document.querySelectorAll('.unlock-btn').forEach(btn => {
        const vipId = parseInt(btn.id.replace('btn-', ''), 10);
        if (!updatedVIPs.includes(vipId)) {
          btn.textContent = btn.dataset.originalText;
          if (!btn.dataset.originalText.includes('🔐') && !btn.disabled) {
            btn.disabled = false;
            btn.classList.remove('completed');
            btn.onclick = () => purchaseVIP(vipId);
          }
        }
      });
    })
    .catch(() => showToast('Error loading task status'));
});

function purchaseVIP(vipId) {
  const btn = document.getElementById('btn-' + vipId);
  if (btn.classList.contains('completed')) {
    window.location.href = 'task_vip.php?vip=' + vipId;
    return;
  }
  btn.disabled = true;
  btn.textContent = 'Processing...';

  fetch(window.location.href, {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: new URLSearchParams({ vip_id: vipId, txn_password: '' })
  })
  .then(res => res.json())
  .then(data => {
    if (data.status === 'success') {
      showToast('Purchase successful!');
      btn.classList.add('completed');
      btn.disabled = true;
      btn.textContent = 'Task Progress: 0/?';
      setTimeout(() => window.location.href = 'task_vip.php?vip=' + vipId, 1000);
    } else if (data.status === 'insufficient') {
      showToast('Insufficient balance');
      btn.disabled = false;
      btn.textContent = btn.dataset.originalText || 'Unlock Now';
    } else {
      showToast(data.message || 'Purchase failed');
      btn.disabled = false;
      btn.textContent = btn.dataset.originalText || 'Unlock Now';
    }
  })
  .catch(() => {
    showToast('Something went wrong');
    btn.disabled = false;
    btn.textContent = btn.dataset.originalText || 'Unlock Now';
  });
}
</script>

<?php include 'bottom_nav.php'; ?>
</body>
</html>