<?php
// help.php
session_start();
include 'db.php';

// Fetch the latest uploaded help photo
$stmt = $conn->query("SELECT file_path FROM help_photos ORDER BY id DESC LIMIT 1");
$photo = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Help</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <style>
    body {
      margin: 0;
      background-color: #000;
      color: #fff;
      font-family: Arial, sans-serif;
    }

    .top-bar {
      background: #111;
      padding: 15px 10px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 999;
    }

    .top-bar .arrow {
      color: white;
      font-size: 20px;
      text-decoration: none;
      margin-right: 10px;
    }

    .top-bar .title {
      flex-grow: 1;
      text-align: center;
      font-weight: bold;
      font-size: 18px;
      margin-right: 30px;
    }

    .photo-container {
      padding: 20px;
      text-align: center;
    }

    img {
      max-width: 90%;
      height: auto;
      border-radius: 10px;
      border: 2px solid #444;
    }
  </style>
</head>
<body>

<div class="top-bar">
  <a class="arrow" href="index.php">&#8592;</a>
  <div class="title">Help</div>
</div>

<div class="photo-container">
  <?php if ($photo): ?>
    <img src="<?= htmlspecialchars($photo['file_path']) ?>" alt="Help Image">
  <?php else: ?>
    <p></p>
  <?php endif; ?>
</div>

</body>
</html>