<?php
session_start();
include 'db.php';
header('Content-Type: application/json');

// ✅ Ensure user is logged in
if (empty($_SESSION['phone'])) {
    echo json_encode([]);
    exit;
}

$phone = $_SESSION['phone'];

// ✅ Get user ID
$stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user_id = $stmt->fetchColumn();
if (!$user_id) {
    echo json_encode([]);
    exit;
}

// ✅ Auto-create vip_day_reductions table if missing
$conn->exec("
    CREATE TABLE IF NOT EXISTS vip_day_reductions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        vip_product_id INT NOT NULL,
        reduced_at DATETIME NOT NULL,
        INDEX idx_user_vip (user_id, vip_product_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

// ✅ Get purchased VIPs
$stmt = $conn->prepare("
    SELECT 
        p.id AS purchase_id,
        p.vip_product_id, 
        p.expire_at,
        v.daily_earning_limit,
        v.valid_days
    FROM purchases p
    JOIN vip_products v ON p.vip_product_id = v.id
    WHERE p.user_id = ? AND p.expire_at > NOW()
");
$stmt->execute([$user_id]);
$purchased_vips = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$purchased_vips) {
    echo json_encode([]);
    exit;
}

$result = [];
$today = new DateTime();

foreach ($purchased_vips as $vip) {
    $vip_id = (int)$vip['vip_product_id'];
    $purchase_id = (int)$vip['purchase_id'];
    $expire_date = new DateTime($vip['expire_at']);

    // ✅ Remaining valid days (include today)
    if ($today > $expire_date) {
        $remaining_days = 0;
    } else {
        $interval = $today->diff($expire_date);
        $remaining_days = $interval->days;
    }

    // ✅ Daily earning limit
    $daily_limit = (int)$vip['daily_earning_limit'];

    // ✅ Count completed tasks today (for this vip)
    $stmt2 = $conn->prepare("
        SELECT COUNT(*) 
        FROM task_records 
        WHERE user_id = ? AND vip_product_id = ? AND DATE(scored_at) = CURDATE()
    ");
    $stmt2->execute([$user_id, $vip_id]);
    $completed = (int)$stmt2->fetchColumn();

    // ✅ Just check if reduced today (no action)
    $stmt3 = $conn->prepare("
        SELECT COUNT(*) 
        FROM vip_day_reductions 
        WHERE user_id = ? AND vip_product_id = ? AND DATE(reduced_at) = CURDATE()
    ");
    $stmt3->execute([$user_id, $vip_id]);
    $already_reduced_today = $stmt3->fetchColumn() > 0;

    // ✅ NO automatic day reduction — only reflect true remaining days
    $result[] = [
        'vip_id' => $vip_id,
        'completed' => $completed,
        'total' => $daily_limit,
        'remaining_days' => max(0, $remaining_days),
        'expire_date' => $expire_date->format('Y-m-d'),
        'already_reduced_today' => $already_reduced_today
    ];
}

echo json_encode($result);
?>