<?php
// === CONFIGURATION ===
$merchantId = 10410;
$apiKey = '6Vl6gcecxrMYkr5U';  // Your OTPpay API Key
$withdrawUrl = 'https://pay.otpay.io/api/payout/submit';

// === USER DATA ===
$walletAddress = 'TSz1f8F4ZWDfC6NLFJ3zkq8E5tn9M6rkHK'; // User USDT Wallet Address
$network = 'USDT-TRC20'; // Use: USDT-TRC20, USDT-BEP20, USDT-ERC20
$amount = 10.00; // Amount to withdraw
$userName = 'John Doe';
$userEmail = 'john@example.com';
$userMobile = '08123456789';
$merchantOrderId = 'trx_' . time(); // Unique order ID

// === Step 1: Build request payload ===
$requestData = [
    "merchantId" => $merchantId,
    "merchantOrderId" => $merchantOrderId,
    "amount" => $amount,
    "notifyUrl" => "https://new-line-cinema.cc/user/reg/otppay_withdraw_notify.php",
    "fundAccount" => [
        "accountType" => "crypto_account",
        "contact" => [
            "name" => $userName,
            "email" => $userEmail,
            "mobile" => $userMobile,
            "address" => "Nigeria"
        ],
        "bankAccount" => [
            "name" => $userName,
            "bankCode" => $network,
            "accountNumber" => $walletAddress
        ]
    ]
];

// === Step 2: Generate Sign ===
// Sign = md5(merchantId + merchantOrderId + amount + apiKey)
$signString = $merchantId . $merchantOrderId . $amount . $apiKey;
$requestData["sign"] = md5($signString);

// === Step 3: Send Request to OTPPay API ===
$ch = curl_init($withdrawUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// === Step 4: Show Response ===
echo "<h3>🔐 Withdraw Request Sent</h3>";
echo "HTTP Code: $httpCode<br>";
echo "Raw Response: $response";
?>