





<?php  
ini_set('display_errors', 1);  
ini_set('display_startup_errors', 1);  
error_reporting(E_ALL);  
session_start();  
if (!isset($_SESSION['phone'])) {  
    header("Location: login.php");  
    exit();  
}  

  
include 'db.php';  
  
$userPhone = $_SESSION['phone'];  
  
// Fetch user data  
$userStmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");  
$userStmt->execute([$userPhone]);  
$userData = $userStmt->fetch(PDO::FETCH_ASSOC);  
$userId = $userData['id'];  
  
// Get total tasks  
$stmt = $conn->prepare("SELECT COUNT(*) FROM task_records WHERE user_id = ?");  
$stmt->execute([$userId]);  
$totalTasks = $stmt->fetchColumn();  
  
// Get today's tasks  
$today = date('Y-m-d');  
$stmt = $conn->prepare("SELECT COUNT(*) FROM task_records WHERE user_id = ? AND DATE(scored_at) = ?");  
$stmt->execute([$userId, $today]);  
$todayTasks = $stmt->fetchColumn();  

  
// Fetch the highest active VIP purchase for the user  
$vip_stmt = $conn->prepare("  
    SELECT v.id AS vip_id, v.name AS vip_name, v.badge_image, v.level,  
           DATE_ADD(p.purchased_at, INTERVAL v.valid_days DAY) AS expiry_date  
    FROM purchases p  
    JOIN vip_products v ON p.vip_product_id = v.id  
    WHERE p.user_id = ?  
      AND DATE_ADD(p.purchased_at, INTERVAL v.valid_days DAY) >= CURDATE()  
    ORDER BY v.level DESC  
    LIMIT 1  
");  
$vip_stmt->execute([$userId]);  
$vip_data = $vip_stmt->fetch(PDO::FETCH_ASSOC);  

  
if ($vip_data) {  
    $vipLevel = $vip_data['vip_name'] ?? 'VIP 0'; // For display  
    $vip_level_num = $vip_data['level'] ?? 0;  
    $vip_badge = $vip_data['badge_image'] ?? 'vip0.png';  
    $vipExpiry = isset($vip_data['expiry_date']) ? date("F j, Y", strtotime($vip_data['expiry_date'])) : 'N/A';  
} else {  
    $vipLevel = 'None';  
    $vip_level_num = 0;  
    $vip_badge = 'vip0.png';  
    $vipExpiry = 'N/A';  
}  
  
// Set vip_id from vip_data  
$vip_id = $vip_data['vip_id'] ?? 0;  
  
// Fetch all videos for this VIP  
$stmt = $conn->prepare("SELECT * FROM videos WHERE vip_product_id = ?");  
$stmt->execute([$vip_id]);  
$videos = $stmt->fetchAll();  
  
// Shuffle the videos randomly on each refresh  
shuffle($videos);  
?> 


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>NLC Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover" />
  <meta name="color-scheme" content="dark" />
  
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">  

  <style>
    /* ─── Global Styles ───────────────────── */
    html, body {
      margin: 0;
      padding: 0;
      height: 100%;
      font-family: Arial, sans-serif;
      color: #fff;

      /* Background image */
      background-image: url('2.png');
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      background-attachment: fixed;
    }

    /* ─── Slider Styles ───────────────────── */
    .slider-box {
      width: 91%;
      max-width: 700px;
      height: 165px;
      overflow: hidden;
      border-radius: 16px;
      margin: 20px auto;
      box-shadow: 0 6px 15px rgba(0,0,0,0.15);
      background: #FFFFFF;
    }

    .slides-box {
      display: flex;
      animation: slidebox 12s infinite ease-in-out;
    }

    .slides-box img {
      flex: 0 0 100%;
      width: 100%;
      height: 250%;
      object-fit: contain;
      transform: translateY(-10px);
    }

    @keyframes slidebox {
      0%   { transform: translateX(0%); }
      15%  { transform: translateX(0%); }
      20%  { transform: translateX(-100%); }
      35%  { transform: translateX(-100%); }
      40%  { transform: translateX(-200%); }
      55%  { transform: translateX(-200%); }
      60%  { transform: translateX(-300%); }
      75%  { transform: translateX(-300%); }
      80%  { transform: translateX(-400%); }
      100% { transform: translateX(-400%); }
    }

    /* ─── Video Card Styles ───────────────── */
    .video-card img {
      height: 148px;
      object-fit: cover;
      border-radius: 0;
    }
    /* Hide horizontal scrollbar for smooth look */
.scrollbar-hide::-webkit-scrollbar {
  display: none;
}
.scrollbar-hide {
  -ms-overflow-style: none;
  scrollbar-width: none;
}
  </style>
</head>




<body class="relative text-white min-h-screen">

  <!-- ░░░ Main Content ░░░ -->
  <div class="relative z-10 p-2 pb-12"> <!-- reduced padding -->
  
  
    <!-- ─── Top Bar ────────────────────────── -->
<div class="flex items-center justify-between mb-2 py-1">
  <!-- Smaller Bold Name -->
  <span class="text-xl font-bold text-white">NLC Dashboard</span>

  <!-- Icons -->
  <div class="flex space-x-3 text-lg">
    <a href="" title="Account Settings">
      <i class="fa-solid fa-mobile-screen"></i>
    </a>
    <a href="" title="Online Support">
      <i class="fa-solid fa-headphones"></i>
    </a>
    <a href="leng.php" title="Change Language">
      <i class="fa-solid fa-globe"></i>
    </a>
  </div>
</div>

    <!-- ─── Slider ─────────────────────────── -->
    <div class="slider-box">
      <div class="slides-box">
        <img src="images/sliderr1.jpg" alt="Banner 1">
        <img src="images/sliderr2.jpg" alt="Banner 2">
        <img src="images/sliderr3.jpg" alt="Banner 3">
        <img src="images/sliderr4.jpg" alt="Banner 4">
        <img src="images/sliderr5.jpg" alt="Banner 5">
      </div>
    </div>

    <!-- ─── Notification Section ──────────── -->
    <div style="background:#1e1e1e; color:#fff; border-radius:10px; margin:15px; padding:15px;">
      <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:10px;">
        <h2 style="font-size:18px; font-weight:600;">Notification</h2>
        <a href="" style="color:#ccc; font-size:14px; text-decoration:none;">See more ›</a>
      </div>

      <!-- Individual Notifications -->
      <?php for ($i = 1; $i <= 7; $i++): ?>
      <a href="notification<?= $i ?>.php" style="text-decoration:none; color:#fff;">
        <div style="display:flex; align-items:center; border-bottom:1px solid #333; padding:10px 0;">
          <div style="width:35px; height:35px; background:#3d3dff; border-radius:50%; display:flex; align-items:center; justify-content:center; margin-right:10px;">
            <i class="fa fa-bell" style="color:#fff;"></i>
          </div>
          <div style="flex:1;">
            <div style="font-weight:600;">Notification <?= $i ?> Title Here</div>
            <div style="font-size:12px; color:#aaa;">2025-XX-XX XX:XX:XX</div>
          </div>
          <img src="images/news<?= $i ?>.jpg" alt="Notification" style="width:55px; height:55px; border-radius:8px; margin-left:10px;">
        </div>
      </a>
      <?php endfor; ?>
    </div>

    <!-- ─── Home Shortcut Icons ───────────── -->
    <div style="
      background-image: url('2.png');
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      color: #fff;
      padding: 20px 10px;
      text-align: center;
      overflow-x: hidden;
      border-radius: 15px;
    ">
      <div style="
        display: grid;
        grid-template-columns: repeat(5, minmax(0, 1fr));
        justify-items: center;
        align-items: center;
        gap: 10px;
        max-width: 100%;
        box-sizing: border-box;
      ">
        <!-- Individual Shortcut Items -->
        <?php
        $shortcuts = [
          ['href'=>'transfer.php','img'=>'recharge.png','label'=>"Recharge<br>Withdraw"],
          ['href'=>'invite.php','img'=>'invite.png','label'=>"Invite"],
          ['href'=>'index.php','img'=>'membership.png','label'=>"Membership"],
          ['href'=>'','img'=>'system.png','label'=>"System"],
          ['href'=>'','img'=>'city.png','label'=>"City"],
        ];
        foreach ($shortcuts as $sc):
        ?>
        <a href="<?= $sc['href'] ?>" style="text-decoration:none; color:#fff;">
          <img src="images/<?= $sc['img'] ?>" alt="<?= $sc['label'] ?>" style="width:50px; height:50px; border-radius:15px; margin-bottom:5px;">
          <div style="font-size:12px;"><?= $sc['label'] ?></div>
        </a>
        <?php endforeach; ?>
      </div>

      <!-- Task Center (Full Row Centered) -->
      <div style="width:100%; display:flex; justify-content:center; margin-top:15px;">
        <a href="index.php" style="text-decoration:none; color:#fff;">
          <img src="images/task.png" alt="Task Center" style="width:50px; height:50px; border-radius:15px; margin-bottom:5px;">
          <div style="font-size:12px;">Task Center</div>
        </a>
      </div>
    </div>
    
    
    
    
<div class="mb-2">  
  <div class="flex justify-between items-center mb-1">  
    <h3 class="font-bold text-white text-xs">|| Supporter</h3>  
    <a href="index.php" class="text-white text-[11px] font-semibold hover:underline">See more &gt;</a>  
  </div>    <div class="flex flex-row justify-between gap-2">  
    <!-- Card 1 -->  
    <div class="flex-1 bg-[#1a1a1a] rounded-xl overflow-hidden shadow-md">  
      <img src="images/agent1.jpg" alt="Agent 1" class="w-full h-9 object-cover rounded-xl" />  
    </div>  <!-- Card 2 -->  
<div class="flex-1 bg-[#1a1a1a] rounded-xl overflow-hidden shadow-md">  
  <img src="images/agent2.jpg" alt="Agent 2" class="w-full h-9 object-cover rounded-xl" />  
</div>  

<!-- Card 3 -->  
<div class="flex-1 bg-[#1a1a1a] rounded-xl overflow-hidden shadow-md">  
  <img src="images/agent3.jpg" alt="Agent 3" class="w-full h-9 object-cover rounded-xl" />  
</div>

  </div>  
</div>


<!-- ─── Popular Movies Section (Styled Like VIP Tasks) ───────────── -->
<div class="mt-4">
  <div class="flex justify-between items-center mb-2">
    <h3 class="font-bold text-white text-xs">|| Popular Movies</h3>
    <a href="" class="text-white text-[11px] font-semibold hover:underline">See more &gt;</a>
  </div>

  <div class="flex gap-3 overflow-x-auto scrollbar-hide pb-2" style="scroll-snap-type:x mandatory;">
    <?php  
    try {
        $stmt = $conn->query("
            SELECT * FROM videos 
            GROUP BY title 
            ORDER BY views DESC, id DESC 
            LIMIT 10
        ");
    } catch (PDOException $e) {
        $stmt = $conn->query("
            SELECT * FROM videos 
            GROUP BY title 
            ORDER BY id DESC 
            LIMIT 10
        ");
    }

    $popularMovies = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $unique = [];
    $filtered = [];
    foreach ($popularMovies as $movie) {
        if (!in_array($movie['title'], $unique)) {
            $unique[] = $movie['title'];
            $filtered[] = $movie;
        }
    }

    foreach ($filtered as $movie):  
        $title = htmlspecialchars($movie['title']);  
        $desc = htmlspecialchars(substr($movie['description'] ?? '', 0, 50));  
        $url = $movie['video_url'];  
        $tickets = rand(630000, 660000);

        // ✅ Generate thumbnail
        if (!empty($movie['thumbnail'])) {  
            $thumb = $movie['thumbnail'];  
        } elseif (strpos($url, 'streamable.com') !== false) {  
            $streamable_id = basename($url);  
            $thumb = "https://cdn-cf-east.streamable.com/image/$streamable_id.jpg";  
        } elseif (strpos($url, 'youtube.com') !== false || strpos($url, 'youtu.be') !== false) {  
            preg_match('/(?:v=|\/)([0-9A-Za-z_-]{11})/', $url, $matches);  
            $youtube_id = $matches[1] ?? '';  
            $thumb = "https://img.youtube.com/vi/$youtube_id/hqdefault.jpg";  
        } else {  
            $thumb = 'https://img.icons8.com/ios/100/ffffff/video.png';  
        }  
    ?>
      <div class="flex-none w-40 bg-[#1a1a1a] rounded-xl overflow-hidden shadow-md scroll-snap-align-start">

        <!-- Thumbnail -->
        <img src="<?= $thumb ?>" alt="<?= $title ?>" class="w-full h-24 object-cover rounded-t-xl">

        <!-- Info -->
        <div class="p-2">
          <div class="text-[11px] font-semibold text-white truncate mb-1"><?= $title ?></div>
          <div class="progress-bar bg-[#333] h-[5px] rounded mb-1 overflow-hidden">
            <div class="progress-fill" style="width: <?= rand(60, 100) ?>%; background: linear-gradient(180deg, #F8D9A0 0%, #FFF4D6 100%); height: 5px;"></div>
          </div>
          <div class="text-[10px] text-gray-400 mb-1"><?= $tickets ?> Ticket</div>

          <!-- Rent button navigates to task_vip.php -->
          <div class="rating-btn w-full text-center bg-gradient-to-b from-[#F8D9A0] to-[#FFF4D6] text-black font-semibold text-[10px] py-[4px] rounded cursor-pointer"
               onclick="window.location.href='index.php?task_id=<?= $movie['id'] ?>'">
            Rent Immediately
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>




<!-- ─── Coming Soon Section (Styled Like VIP Tasks) ───────────── -->
<div class="mt-6">
  <div class="flex justify-between items-center mb-2">
    <h3 class="font-bold text-white text-xs">|| Coming Soon</h3>
    <a href="" class="text-white text-[11px] font-semibold hover:underline">See more &gt;</a>
  </div>

  <div class="grid grid-cols-2 gap-3 px-1">
    <?php  
    try {
        $stmt = $conn->query("
            SELECT id, title, video_url, thumbnail, description 
            FROM videos 
            WHERE status = 'coming_soon' 
            ORDER BY id DESC 
            LIMIT 30
        ");
    } catch (PDOException $e) {
        $stmt = $conn->query("
            SELECT id, title, video_url, thumbnail, description 
            FROM videos 
            ORDER BY id DESC 
            LIMIT 30
        ");
    }

    $comingMovies = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // ✅ Filter unique titles
    $uniqueMovies = [];
    $titles = [];
    foreach ($comingMovies as $movie) {
        if (!in_array($movie['title'], $titles)) {
            $titles[] = $movie['title'];
            $uniqueMovies[] = $movie;
        }
    }

    // ✅ Limit to only 8 unique movies
    $moviesToShow = array_slice($uniqueMovies, 0, 8);

    foreach ($moviesToShow as $movie):  
        $title = htmlspecialchars($movie['title']);  
        $url = $movie['video_url'];  
        $desc = htmlspecialchars(substr($movie['description'] ?? '', 0, 50));  
        $tickets = rand(120000, 140000);

        // ✅ Thumbnail logic
        if (!empty($movie['thumbnail'])) {  
            $thumb = $movie['thumbnail'];  
        } elseif (strpos($url, 'streamable.com') !== false) {  
            $streamable_id = basename($url);  
            $thumb = "https://cdn-cf-east.streamable.com/image/$streamable_id.jpg";  
        } elseif (strpos($url, 'youtube.com') !== false || strpos($url, 'youtu.be') !== false) {  
            preg_match('/(?:v=|\/)([0-9A-Za-z_-]{11})/', $url, $matches);  
            $youtube_id = $matches[1] ?? '';  
            $thumb = "https://img.youtube.com/vi/$youtube_id/hqdefault.jpg";  
        } else {  
            $thumb = 'https://img.icons8.com/ios/100/ffffff/video.png';  
        }  
    ?>
<div class="bg-[#1a1a1a] rounded-xl overflow-hidden shadow-md cursor-pointer"
     onclick="window.location.href='index.php?task_id=<?= $movie['id'] ?>'">

  <!-- Thumbnail -->
  <img src="<?= $thumb ?>" alt="<?= $title ?>" class="w-full h-28 object-cover rounded-t-xl">

  <!-- Info -->
  <div class="p-2">
    <div class="text-[11px] font-semibold text-white truncate mb-1"><?= $title ?></div>

    <!-- Progress bar -->
    <div class="progress-bar bg-[#333] h-[5px] rounded mb-1 overflow-hidden">
      <div class="progress-fill" style="width: <?= rand(50, 100) ?>%; background: linear-gradient(180deg, #F8D9A0 0%, #FFF4D6 100%); height: 5px;"></div>
    </div>

    <!-- Ticket count -->
    <div class="text-[10px] text-gray-400 mb-1"><?= $tickets ?> Ticket</div>

    <!-- Rent button -->
    <div class="rating-btn w-full text-center bg-gradient-to-b from-[#F8D9A0] to-[#FFF4D6] text-black font-semibold text-[10px] py-[4px] rounded">
      Rent Immediately
    </div>
  </div>
</div>


       
    <?php endforeach; ?>
  </div>
</div>


  </div><!-- /Main Content -->

  <!-- ─── Bottom Navigation ───────────────── -->
  <?php include 'bottom_nav.php'; ?>

  <!-- ─── Slider Script ─────────────────── -->
  <script>
    let sliderIndex = 0;
    const track = document.getElementById('slider-track');
    if (track) {
      const slides = track.children;
      const totalSlides = slides.length;
      setInterval(() => {
        sliderIndex = (sliderIndex + 1) % totalSlides;
        track.style.transform = `translateX(-${sliderIndex * 100}%)`;
      }, 3000);
    }
  </script>

<!-- ─── Customer Service Contact Icons ────────── -->

<!-- WhatsApp Floating Icon -->
<a 
  href="https://wa.me/447902954842" 
  target="_blank" 
  class="whatsapp-float" 
  title="Customer Service (WhatsApp)"
  style="
    position: fixed;
    bottom: 130px;
    right: 25px;
    background: linear-gradient(to bottom, #F8D9A0, #FFF4D6);
    color: black;
    border-radius: 50%;
    width: 48px;
    height: 48px;
    text-align: center;
    font-size: 22px;
    line-height: 48px;
    box-shadow: 0 3px 8px rgba(0,0,0,0.25);
    z-index: 9999;
    transition: transform 0.3s, box-shadow 0.3s;
  "
  onmouseover="this.style.transform='scale(1.1)';this.style.boxShadow='0 5px 12px rgba(0,0,0,0.35)'"
  onmouseout="this.style.transform='scale(1)';this.style.boxShadow='0 3px 8px rgba(0,0,0,0.25)'"
>
  <i class="fab fa-whatsapp"></i>
</a>

<!-- Telegram Floating Icon -->
<a 
  href="https://t.me/YourTelegramUsername" 
  target="_blank" 
  class="telegram-float" 
  title="Customer Service (Telegram)"
  style="
    position: fixed;
    bottom: 70px;
    right: 25px;
    background: linear-gradient(to bottom, #F8D9A0, #FFF4D6);
    color: black;
    border-radius: 50%;
    width: 48px;
    height: 48px;
    text-align: center;
    font-size: 22px;
    line-height: 48px;
    box-shadow: 0 3px 8px rgba(0,0,0,0.25);
    z-index: 9999;
    transition: transform 0.3s, box-shadow 0.3s;
  "
  onmouseover="this.style.transform='scale(1.1)';this.style.boxShadow='0 5px 12px rgba(0,0,0,0.35)'"
  onmouseout="this.style.transform='scale(1)';this.style.boxShadow='0 3px 8px rgba(0,0,0,0.25)'"
>
  <i class="fab fa-telegram-plane"></i>
</a>

<!-- Font Awesome CDN (for icons) -->
<link
  rel="stylesheet"
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
/>
<!-- ─── Popup Image Viewer ──────────────── -->
<div id="popupOverlay" style="
  display:none;
  position:fixed;
  top:0; left:0; right:0; bottom:0;
  background:rgba(0,0,0,0.85);
  z-index:10000;
  justify-content:center;
  align-items:center;
  flex-direction:column;
">
  <div id="popupSlider" style="
    position:relative;
    width:90%;
    max-width:380px;
    overflow:hidden;
    border-radius:15px;
    background:#000;
  ">
    <div id="popupSlides" style="
      display:flex;
      transition:transform 0.4s ease-in-out;
    ">
      <!-- Add your images here -->
      <img src="images/sliderr1.jpg" style="width:100%; flex-shrink:0; object-fit:cover;">
      <img src="images/sliderr2.jpg" style="width:100%; flex-shrink:0; object-fit:cover;">
      <img src="images/sliderr3.jpg" style="width:100%; flex-shrink:0; object-fit:cover;">
    </div>
  </div>

  <!-- Close Button at the Bottom -->
  <button onclick="closePopup()" style="
    margin-top:20px;
    background:linear-gradient(to bottom, #F8D9A0, #FFF4D6);
    color:black;
    border:none;
    border-radius:25px;
    padding:10px 25px;
    font-size:15px;
    font-weight:600;
    cursor:pointer;
    box-shadow:0 3px 8px rgba(0,0,0,0.25);
  ">
    Close
  </button>
</div>

<script>
  let currentIndex = 0;
  const slides = document.getElementById('popupSlides');
  const totalSlides = slides.children.length;

  function openPopup() {
    document.getElementById('popupOverlay').style.display = 'flex';
  }

  function closePopup() {
    document.getElementById('popupOverlay').style.display = 'none';
  }

  // Swipe gesture support
  let startX = 0;
  slides.addEventListener('touchstart', e => startX = e.touches[0].clientX);
  slides.addEventListener('touchend', e => {
    let endX = e.changedTouches[0].clientX;
    if (startX - endX > 50) nextSlide();
    else if (endX - startX > 50) prevSlide();
  });

  function nextSlide() {
    currentIndex = (currentIndex + 1) % totalSlides;
    slides.style.transform = `translateX(-${currentIndex * 100}%)`;
  }

  function prevSlide() {
    currentIndex = (currentIndex - 1 + totalSlides) % totalSlides;
    slides.style.transform = `translateX(-${currentIndex * 100}%)`;
  }

  // Auto open popup when page loads (you can remove this)
  window.addEventListener('load', () => {
    setTimeout(openPopup, 1000);
  });
</script>
</body>
</html>