<?php
session_start();
require_once 'admin_db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

// Handle delete
if (isset($_GET['delete'])) {
    $delete_id = $_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM vip_products WHERE id = ?");
    if ($stmt->execute([$delete_id])) {
        $_SESSION['delete_success'] = true;
        header("Location: product.php");
        exit();
    }
}

// Fetch all VIP products
$stmt = $conn->query("SELECT * FROM vip_products ORDER BY id DESC");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>VIP Products</title>
  <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f9f9f9;
      padding: 20px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      background: #fff;
    }
    th, td {
      padding: 10px;
      border: 1px solid #ccc;
      text-align: center;
    }
    th {
      background: #800000;
      color: white;
    }
    img {
      width: 60px;
      height: auto;
    }
    .actions a {
      padding: 5px 10px;
      margin: 2px;
      background: #800000;
      color: white;
      text-decoration: none;
      border-radius: 5px;
    }
    .actions a.delete {
      background: darkred;
    }
    .top-bar {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 15px;
    }
    .top-bar h2 {
      margin: 0;
    }
    .top-bar a {
      background: #800000;
      color: white;
      padding: 10px 15px;
      text-decoration: none;
      border-radius: 5px;
    }
  </style>
</head>
<body>

<div class="top-bar">
  <h2>VIP Products</h2>
  <a href="add_vip_product.php">+ Add New Product</a>
</div>

<table>
  <thead>
    <tr>
      <th>Image</th>
      <th>Name</th>
      <th>Price (USDT)</th>
      <th>Viewing Income</th>
      <th>Daily Limit</th>
      <th>Valid Days</th>
      <th>Agent Only</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php if (count($products) > 0): ?>
      <?php foreach ($products as $product): ?>
        <tr>
          <td><img src="../../<?= htmlspecialchars($product['img']) ?>" alt="Product"></td>
          <td><?= htmlspecialchars($product['name']) ?></td>
          <td><?= htmlspecialchars($product['amount']) ?></td>
          <td><?= htmlspecialchars($product['viewing_income']) ?></td>
          <td><?= htmlspecialchars($product['daily_earning_limit']) ?></td>
          <td><?= htmlspecialchars($product['valid_days']) ?></td>
          <td><?= $product['agent_only'] ? 'Yes' : 'No' ?></td>
          <td class="actions">
            <a href="edit_vip_product.php?id=<?= $product['id'] ?>">Edit</a>
            <a href="javascript:void(0);" class="delete" onclick="confirmDelete(<?= $product['id'] ?>)">Delete</a>
          </td>
        </tr>
      <?php endforeach; ?>
    <?php else: ?>
      <tr><td colspan="8">No products found.</td></tr>
    <?php endif; ?>
  </tbody>
</table>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
  <?php if (isset($_SESSION['delete_success'])): ?>
    Swal.fire('Deleted!', 'Product deleted successfully.', 'success');
    <?php unset($_SESSION['delete_success']); ?>
  <?php endif; ?>

  function confirmDelete(id) {
    Swal.fire({
      title: 'Are you sure?',
      text: "Do you want to delete this product?",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#800000',
      cancelButtonColor: '#888',
      confirmButtonText: 'Yes, delete it'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = "product.php?delete=" + id;
      }
    });
  }
</script>

</body>
</html>