<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

require_once 'admin_db.php';

// Handle add product form
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_product'])) {
    $name = $_POST['name'];
    $description = $_POST['description'];
    $price = $_POST['price'];
    $validity_days = $_POST['validity_days'];
    $viewing_income = $_POST['viewing_income'];
    $watch_limit = $_POST['watch_limit'];
    $img_path = 'vip_images/default.png';

    // Image upload
    if (!empty($_FILES['image']['name'])) {
        $target_dir = "vip_images/";
        $filename = basename($_FILES["image"]["name"]);
        $img_path = $target_dir . time() . '_' . $filename;
        move_uploaded_file($_FILES["image"]["tmp_name"], $img_path);
    }

    $stmt = $pdo->prepare("INSERT INTO vip_products (name, description, price, validity_days, viewing_income, watch_limit, img) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$name, $description, $price, $validity_days, $viewing_income, $watch_limit, $img_path]);
}

// Handle delete
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM vip_products WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: vip_admin.php");
    exit();
}

// Fetch products
$stmt = $pdo->query("SELECT * FROM vip_products ORDER BY id DESC");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>VIP Product Admin</title>
    <style>
        body {
            font-family: sans-serif;
            padding: 20px;
            background: #f9f9f9;
        }
        h2 { margin-bottom: 10px; }
        form, table {
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 40px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        input, textarea {
            padding: 10px;
            margin: 5px 0 15px;
            width: 100%;
        }
        input[type="submit"] {
            background: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            width: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 12px;
        }
        img {
            max-height: 60px;
        }
    </style>
</head>
<body>

<h2>Admin: Add VIP Product</h2>
<form method="post" enctype="multipart/form-data">
    <input type="text" name="name" placeholder="Product name" required>
    <textarea name="description" placeholder="Product description"></textarea>
    <input type="number" name="price" step="0.01" placeholder="Price (USDT)" required>
    <input type="number" name="validity_days" placeholder="Validity (in days)" required>
    <input type="number" name="viewing_income" placeholder="Viewing income per task" required>
    <input type="number" name="watch_limit" placeholder="Daily watch limit" required>
    <input type="file" name="image">
    <input type="submit" name="add_product" value="Add Product">
</form>

<h2>VIP Product List</h2>
<table>
    <tr>
        <th>Image</th>
        <th>Name</th>
        <th>USDT</th>
        <th>Validity</th>
        <th>Income</th>
        <th>Limit</th>
        <th>Action</th>
    </tr>
    <?php foreach ($products as $p): ?>
    <tr>
        <td><img src="<?= $p['img'] ?>" alt=""></td>
        <td><?= htmlspecialchars($p['name']) ?></td>
        <td>$<?= $p['price'] ?></td>
        <td><?= $p['validity_days'] ?> days</td>
        <td>$<?= $p['viewing_income'] ?></td>
        <td><?= $p['watch_limit'] ?>/day</td>
        <td><a href="?delete=<?= $p['id'] ?>" onclick="return confirm('Delete this product?')">Delete</a></td>
    </tr>
    <?php endforeach; ?>
</table>

</body>
</html>