<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include('admin_db.php');

// Fetch VIPs
$vip_stmt = $conn->prepare("SELECT id, name FROM vip_products ORDER BY id ASC");
$vip_stmt->execute();
$vip_products = $vip_stmt->fetchAll();

// Ensure folders exist in public_html
$video_folder = $_SERVER['DOCUMENT_ROOT'].'/uploads/videos/';
$thumb_folder = $_SERVER['DOCUMENT_ROOT'].'/uploads/thumbnails/';

if (!is_dir($video_folder)) mkdir($video_folder, 0755, true);
if (!is_dir($thumb_folder)) mkdir($thumb_folder, 0755, true);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';
    $vip_product_id = $_POST['vip_product_id'] ?? '';
    $video_link = trim($_POST['video_link'] ?? '');

    $video_url = '';
    $thumbnail_url = '';

    if ($vip_product_id && $title) {

        // --- Video upload or link ---
        if (!empty($video_link)) {
            $video_url = $video_link;
        } elseif (!empty($_FILES['video']['tmp_name'])) {
            $video_name = time() . '_' . basename($_FILES['video']['name']);
            $video_path = $video_folder . $video_name;
            $video_url  = '/uploads/videos/' . $video_name;
            move_uploaded_file($_FILES['video']['tmp_name'], $video_path);
        }

        // --- Thumbnail upload ---
        if (!empty($_FILES['thumbnail']['tmp_name'])) {
            $thumb_name = time() . '_thumb_' . basename($_FILES['thumbnail']['name']);
            $thumb_path = $thumb_folder . $thumb_name;
            move_uploaded_file($_FILES['thumbnail']['tmp_name'], $thumb_path);
            $thumbnail_url = '/uploads/thumbnails/' . $thumb_name;
        } else {
            // Auto-generate thumbnail from local video if available
            if (!empty($_FILES['video']['tmp_name'])) {
                $thumbnail_name = time() . '_thumb.jpg';
                $thumbnail_path = $thumb_folder . $thumbnail_name;
                $ffmpeg_cmd = "ffmpeg -i \"$video_path\" -ss 00:00:03 -vframes 1 \"$thumbnail_path\"";
                exec($ffmpeg_cmd);
                $thumbnail_url = '/uploads/thumbnails/' . $thumbnail_name;
            }
        }

        if ($video_url) {
            $stmt = $conn->prepare("INSERT INTO videos (title, description, video_url, vip_product_id, thumbnail) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$title, $description, $video_url, $vip_product_id, $thumbnail_url]);
            echo "<p style='color:lime;'>✅ Video uploaded successfully!</p>";
        } else {
            echo "<p style='color:red;'>❌ No video link or file uploaded.</p>";
        }

    } else {
        echo "<p style='color:red;'>❌ All fields are required.</p>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Upload VIP Video</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { background-color: #111; color: white; font-family: Arial; padding: 20px; }
        form { background-color: #1e1e1e; padding: 20px; border-radius: 10px; }
        input, select, textarea { width: 100%; padding: 10px; margin: 10px 0; background: #2a2a2a; color: white; border: none; border-radius: 5px; }
        button { background-color: #caa076; color: black; padding: 10px; border: none; border-radius: 5px; font-weight: bold; cursor: pointer; }
        button:hover { opacity: 0.9; }
        label { margin-top: 10px; display: block; }
        small { color: #888; display: block; margin-top: -8px; margin-bottom: 10px; }
    </style>
</head>
<body>

<h2>🎥 Upload or Paste VIP Task Video</h2>

<form method="POST" enctype="multipart/form-data">
    <label>Video Title</label>
    <input type="text" name="title" required>

    <label>Video Description</label>
    <textarea name="description" rows="3" placeholder="Enter a short description"></textarea>

    <label>Select VIP</label>
    <select name="vip_product_id" required>
        <option value="">-- Choose VIP --</option>
        <?php foreach ($vip_products as $vip): ?>
            <option value="<?= $vip['id'] ?>"><?= htmlspecialchars($vip['name']) ?></option>
        <?php endforeach; ?>
    </select>

    <label>Paste Video Link (YouTube / Streamable / MP4)</label>
    <input type="url" name="video_link" placeholder="https://example.com/video.mp4">
    <small>Or upload a video below (if no link is pasted)</small>

    <label>Upload MP4 Video</label>
    <input type="file" name="video" accept="video/mp4">

    <label>Upload Thumbnail</label>
    <input type="file" name="thumbnail" accept="image/*">
    <small>This image will appear as the video cover on the user side.</small>

    <button type="submit">Upload Video</button>
</form>

</body>
</html>