<?php
// admin/referral_settings.php
session_start();
include 'admin_db.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $referral_bonus = $_POST['referral_bonus_percent'];
    $level1 = $_POST['level1_rebate_percent'];
    $level2 = $_POST['level2_rebate_percent'];
    $level3 = $_POST['level3_rebate_percent'];

    $stmt = $conn->prepare("UPDATE referral_settings SET referral_bonus_percent = ?, level1_rebate_percent = ?, level2_rebate_percent = ?, level3_rebate_percent = ? WHERE id = 1");
    $stmt->execute([$referral_bonus, $level1, $level2, $level3]);

    $success = "Settings updated successfully!";
}

// Fetch current values
$stmt = $conn->prepare("SELECT * FROM referral_settings WHERE id = 1");
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Referral Settings</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f9f9f9; }
        form { background: #fff; padding: 20px; border-radius: 6px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        label { display: block; margin-top: 15px; }
        input[type="number"] { width: 100%; padding: 8px; margin-top: 5px; }
        button { margin-top: 20px; padding: 10px 20px; background: #333; color: white; border: none; cursor: pointer; }
    </style>
</head>
<body>

<h2>Referral & Rebate Settings</h2>

<?php if (isset($success)): ?>
    <p style="color: green;"><?= $success ?></p>
<?php endif; ?>

<form method="POST">
    <label>Referral Bonus % (on VIP Purchase)</label>
    <input type="number" step="0.01" name="referral_bonus_percent" value="<?= $settings['referral_bonus_percent'] ?>" required>

    <label>Level 1 Daily Rebate %</label>
    <input type="number" step="0.01" name="level1_rebate_percent" value="<?= $settings['level1_rebate_percent'] ?>" required>

    <label>Level 2 Daily Rebate %</label>
    <input type="number" step="0.01" name="level2_rebate_percent" value="<?= $settings['level2_rebate_percent'] ?>" required>

    <label>Level 3 Daily Rebate %</label>
    <input type="number" step="0.01" name="level3_rebate_percent" value="<?= $settings['level3_rebate_percent'] ?>" required>

    <button type="submit">Update Settings</button>
</form>

</body>
</html>