<?php  
ini_set('display_errors', 1);  
ini_set('display_startup_errors', 1);  
error_reporting(E_ALL);  
session_start();  
require_once 'admin_db.php';  

if (!isset($_SESSION['admin_logged_in'])) {  
    header("Location: login.php");  
    exit();  
}  

// ✅ Get product ID (allow 0 as valid)
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
if ($id === null) {  
    echo "No VIP id specified.";  
    exit();  
}  

// Fetch product by id  
$stmt = $conn->prepare("SELECT * FROM vip_products WHERE id = ?");  
$stmt->execute([$id]);  
$product = $stmt->fetch(PDO::FETCH_ASSOC);  
if (!$product) {  
    echo "No VIP products found.";  
    exit();  
}  

$success = false;  

if ($_SERVER['REQUEST_METHOD'] === 'POST') {  
    $name               = $_POST['name'];  
    $viewing_income     = $_POST['viewing_income'];  
    $daily_earning_limit= $_POST['daily_earning_limit'];  
    $valid_days         = $_POST['valid_days'];  
    $agent_only         = isset($_POST['is_agent_only']) ? 1 : 0;  
    $description        = $_POST['description'];  
    $amount             = $_POST['amount'];  
    $referral_bonus     = $_POST['referral_bonus'];  
    $img                = $product['img'];  

    // Handle image upload  
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {  
        $uploadDir = '../../images/vip/';  
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);  
        $uploadFile = $uploadDir . basename($_FILES['image']['name']);  
        if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadFile)) {  
            $img = 'images/vip/' . basename($_FILES['image']['name']);  
        }  
    }  

    // Update by id  
    $stmt = $conn->prepare("UPDATE vip_products SET   
        name = ?, viewing_income = ?, daily_earning_limit = ?, valid_days = ?,   
        agent_only = ?, description = ?, amount = ?, referral_bonus = ?, img = ?   
        WHERE id = ?");  
    $success = $stmt->execute([  
        $name, $viewing_income, $daily_earning_limit, $valid_days,  
        $agent_only, $description, $amount, $referral_bonus, $img, $id  
    ]);  

    if ($success) {  
        $_SESSION['update_success'] = true;  
        header("Location: edit_vip_product.php?id=$id");  
        exit();  
    }  
}  

// Handle Delete  
if (isset($_GET['delete']) && $_GET['delete'] == 'true') {  
    $deleteStmt = $conn->prepare("DELETE FROM vip_products WHERE id = ?");  
    $deleteStmt->execute([$id]);  
    echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>  
    <script>  
        Swal.fire({  
            icon: 'success',  
            title: 'Deleted',  
            text: 'VIP Product has been deleted.',  
            confirmButtonColor: '#800000'  
        }).then(() => { window.location.href = 'dashboard.php'; });  
    </script>";  
    exit();  
}  
?>  

<!DOCTYPE html>  
<html lang="en">  
<head>  
  <meta charset="UTF-8">  
  <title>Edit VIP Product</title>  
  <meta name="viewport" content="width=device-width, initial-scale=1.0">  
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>  
  <style>  
    body { font-family: Arial; background: #f2f2f2; padding: 20px; }  
    .form-container { background: #fff; padding: 25px; border-radius: 10px; box-shadow: 0 0 15px rgba(0,0,0,0.1); max-width: 600px; margin: auto; }  
    h2 { text-align: center; color: #800000; }  
    label { display: block; margin: 10px 0 5px; font-weight: bold; }  
    input, textarea, select { width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 6px; }  
    .submit-btn { background: #800000; color: white; padding: 12px; border: none; border-radius: 6px; cursor: pointer; width: 100%; font-size: 16px; }  
    .submit-btn:hover { background: #a00000; }  
    img { max-height: 100px; margin-top: 10px; }  
    .delete-btn { background: red; color: white; padding: 12px; border: none; border-radius: 6px; cursor: pointer; width: 100%; font-size: 16px; margin-top: 20px; }  
  </style>  
</head>  
<body>  

<div class="form-container">  
  <h2>Edit VIP Product (ID <?= $id ?>)</h2>  

  <form method="POST" enctype="multipart/form-data">  
    <label>Name</label>  
    <input type="text" name="name" value="<?= htmlspecialchars($product['name'] ?? '') ?>" required>  

    <label>Amount</label>  
    <input type="number" name="amount" value="<?= htmlspecialchars($product['amount'] ?? '') ?>" required>  

    <label>Viewing Income</label>  
    <input type="number" name="viewing_income" step="0.01" value="<?= htmlspecialchars($product['viewing_income'] ?? '') ?>" required>  

    <label>Daily Earning Limit</label>  
    <input type="number" name="daily_earning_limit" value="<?= htmlspecialchars($product['daily_earning_limit'] ?? '') ?>" required>  

    <label>Valid Days</label>  
    <input type="number" name="valid_days" value="<?= htmlspecialchars($product['valid_days'] ?? '') ?>" required>  

    <label>Referral Bonus (USDT)</label>  
    <input type="number" name="referral_bonus" step="0.01" value="<?= htmlspecialchars($product['referral_bonus'] ?? '') ?>" required>  

    <label>Description</label>  
    <textarea name="description" rows="3"><?= htmlspecialchars($product['description'] ?? '') ?></textarea>  

    <label>Agent Only</label>  
    <select name="is_agent_only">  
      <option value="0" <?= ($product['agent_only'] ?? 0) == 0 ? 'selected' : '' ?>>No</option>  
      <option value="1" <?= ($product['agent_only'] ?? 0) == 1 ? 'selected' : '' ?>>Yes</option>  
    </select>  

    <label>Product Image</label>  
    <input type="file" name="image">  
    <?php if (!empty($product['img'])): ?>  
      <img src="../../<?= htmlspecialchars($product['img'] ?? '') ?>" alt="Product Image">  
    <?php endif; ?>  

    <button type="submit" class="submit-btn">Update Product</button>  
  </form>  

  <!-- Delete Button -->  
  <form method="GET" onsubmit="return confirmDelete();">  
    <input type="hidden" name="id" value="<?= $id ?>">  
    <input type="hidden" name="delete" value="true">  
    <button type="submit" class="delete-btn">Delete Product</button>  
  </form>  
</div>  

<script>  
  function confirmDelete() { return confirm("Are you sure you want to delete this VIP product?"); }  

  <?php if (isset($_SESSION['update_success'])): ?>  
    Swal.fire({  
      icon: 'success',  
      title: 'Success',  
      text: 'VIP Product updated successfully!',  
      confirmButtonColor: '#800000'  
    });  
    <?php unset($_SESSION['update_success']); ?>  
  <?php endif; ?>  
</script>  

</body>  
</html>