<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include 'admin_db.php'; // DB connection file

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

// Fetch totals
$total_users = $conn->query("SELECT COUNT(*) FROM users")->fetchColumn();

// Withdrawals
$total_withdraw_pending  = $conn->query("SELECT COUNT(*) FROM withdrawals WHERE status='pending'")->fetchColumn();
$total_withdraw_approved = $conn->query("SELECT COUNT(*) FROM withdrawals WHERE status='approved'")->fetchColumn();

// Recharges
$total_recharge_pending  = $conn->query("SELECT COUNT(*) FROM recharge_records WHERE status='pending'")->fetchColumn();
$total_recharge_approved = $conn->query("SELECT COUNT(*) FROM recharge_records WHERE status='approved'")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">    
  <meta name="viewport" content="width=device-width, initial-scale=1.0">    
  <title>Admin Dashboard</title>    
  <style>    
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f4f4f4;
    }

    .sidebar {
      width: 240px;
      height: 100vh;
      background: #800000;
      color: #fff;
      position: fixed;
      top: 0;
      left: 0;
      display: flex;
      flex-direction: column;
      padding-top: 20px;
    }

    .sidebar h2 {
      text-align: center;
      margin-bottom: 30px;
      font-size: 22px;
    }

    .sidebar a {
      color: #fff;
      padding: 15px 20px;
      text-decoration: none;
      font-weight: bold;
      display: block;
    }

    .sidebar a:hover {
      background: #a00000;
    }

    .content {
      margin-left: 240px;
      padding: 20px;
    }

    .top-bar {
      background: #fff;
      padding: 10px 20px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
      font-size: 18px;
      font-weight: bold;
    }

    .stats-container {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
      gap: 20px;
      margin-top: 20px;
    }

    .stat-box {
      background: #fff;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
      text-align: center;
    }

    .stat-box h2 {
      margin: 0;
      font-size: 24px;
      color: #800000;
    }

    .stat-box p {
      margin-top: 8px;
      font-size: 14px;
      color: #555;
    }
  </style>
</head>
<body>

<div class="sidebar">    
  <h2>||| Admin</h2>    
  <a href="product.php">Products</a>    
  <a href="admin_gift.php">Gifts</a>    
  <a href="upload_vip_image.php">VIP image</a>    
  <a href="upload_video.php">Upload Video</a>    
  <a href="settings.php">Settings</a>    
  <a href="referral_settings.php">Referral Settings</a>  
  <a href="upload_vip_image.php">Product image</a>    
  <a href="admin_recharge.php">Recharge</a>
  <a href="admin_users.php">Users</a>
  <a href="admin_withdrawal.php">Withdrawals</a>
  <a href="review_recharge.php">Review Recharge</a>
  <a href="agent.php">Agent Management</a>
</div>

<div class="content">
  <div class="top-bar">Admin Dashboard</div>
  <div id="main-content">

    <!-- ✅ Stats Section -->
    <div class="stats-container">
      <div class="stat-box">
        <h2><?php echo number_format($total_users); ?></h2>
        <p>Total Users</p>
      </div>

      <div class="stat-box">
        <h2><?php echo number_format($total_withdraw_pending); ?></h2>
        <p>Pending Withdrawals</p>
      </div>

      <div class="stat-box">
        <h2><?php echo number_format($total_withdraw_approved); ?></h2>
        <p>Approved Withdrawals</p>
      </div>

      <div class="stat-box">
        <h2><?php echo number_format($total_recharge_pending); ?></h2>
        <p>Pending Recharges</p>
      </div>

      <div class="stat-box">
        <h2><?php echo number_format($total_recharge_approved); ?></h2>
        <p>Approved Recharges</p>
      </div>
    </div>

    <div class="card">
      <h3>Welcome to Admin Dashboard</h3>    
      <p>Select a section from the menu to view data.</p>    
    </div>

  </div>
</div>

</body>
</html>