<?php
include 'admin_db.php';

if (!isset($_GET['id']) || !isset($_GET['action'])) {
    die("Invalid request");
}

$id = intval($_GET['id']);
$action = $_GET['action'];

// Fetch withdrawal
$stmt = $conn->prepare("SELECT w.*, u.phone FROM withdrawals w 
    LEFT JOIN users u ON u.id = w.user_id 
    WHERE w.id=?");
$stmt->execute([$id]);
$withdrawal = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$withdrawal) {
    die("Withdrawal not found");
}

// Check status
if ($withdrawal['status'] !== 'pending') {
    die("This withdrawal is already processed.");
}

// Manual approval
if ($action === 'manual') {
    $update = $conn->prepare("UPDATE withdrawals SET status='approved' WHERE id=?");
    $update->execute([$id]);
    echo "Withdrawal #{$id} manually approved.";
}

// Reject withdrawal
elseif ($action === 'reject') {
    $update = $conn->prepare("UPDATE withdrawals SET status='rejected' WHERE id=?");
    $update->execute([$id]);
    echo "Withdrawal #{$id} rejected.";
}

// KBPay approval
elseif ($action === 'kbpay') {
    if ($withdrawal['type'] !== 'bank') {
        die("Invalid withdrawal type for KBPay");
    }

    $merchant_no = "6086195"; 
    $payout_key  = "OjkHz6bMB74qxRlfuksXXBIoAxcKFouB"; 
    $order_no    = "WD" . $withdrawal['id'] . time();

    $params = [
        "merchant_no"   => $merchant_no,
        "order_no"      => $order_no,
        "order_amount"  => number_format($withdrawal['amount'], 2, '.', ''),
        "timestamp"     => time(),
        "account_no"    => $withdrawal['bank_account_number'],
        "account_name"  => $withdrawal['bank_account_name'],
        "bank_code"     => "10825", // KBPay bank code
        "payout_method" => "10142"  // KBPay payout method
    ];

    // Build sign
    $sign_str  = urldecode(http_build_query($params)) . "&key=" . $payout_key;
    $params["sign"] = md5($sign_str);

    // Send POST
    $ch = curl_init("https://api.kbpay.io/payout/submit"); // Production endpoint
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $res = json_decode($response, true);

    if ($res && $res['code'] == 1000) {
        // KBPay accepted, mark as processing
        $update = $conn->prepare("UPDATE withdrawals SET status='processing', kbpay_order_no=?, kbpay_response=? WHERE id=?");
        $update->execute([$order_no, $response, $id]);
        echo "Withdrawal #{$id} sent to KBPay. Awaiting confirmation.<br>Response: " . $response;
    } else {
        // KBPay failed, refund user
        $update_user = $conn->prepare("UPDATE users SET flexible_wallet = flexible_wallet + ? WHERE id=?");
        $update_user->execute([$withdrawal['amount'], $withdrawal['user_id']]);

        $update_withdraw = $conn->prepare("UPDATE withdrawals SET status='failed', kbpay_response=? WHERE id=?");
        $update_withdraw->execute([$response, $id]);

        echo "Withdrawal #{$id} failed KBPay request. User refunded.<br>Response: " . $response;
    }
}

else {
    echo "Unknown action.";
}

echo "<br><a href='admin_withdrawal.php'>Back</a>";
?>