<?php
// approve_recharge.php
session_start();
include 'admin_db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid recharge ID");
}

$id = (int)$_GET['id'];

// Fetch recharge record
$stmt = $conn->prepare("SELECT phone, amount, status FROM recharge_records WHERE id = :id");
$stmt->execute([':id' => $id]);
$recharge = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$recharge || $recharge['status'] !== 'pending') {
    die("Recharge not found or already processed.");
}

// Update status to approved
$stmt = $conn->prepare("UPDATE recharge_records SET status = 'approved' WHERE id = :id");
$stmt->execute([':id' => $id]);

// Credit user wallet
$stmt = $conn->prepare("UPDATE users SET balance = balance + :amount WHERE phone = :phone");
$stmt->execute([
    ':amount' => $recharge['amount'],
    ':phone' => $recharge['phone']
]);

// Redirect back to admin page
header("Location: admin_recharges.php?success=1");
exit;