<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include 'admin_db.php'; // Adjust path to your DB connection

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

$message = "";
$user = null;
$products = [300, 600, 1000]; // You can add more VIP product amounts here

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['search_phone'])) {
        // Search user by phone
        $phone = trim($_POST['search_phone']);
        $stmt = $conn->prepare("SELECT id, phone FROM users WHERE phone = ?");
        $stmt->execute([$phone]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            $message = "❌ No user found with phone: " . htmlspecialchars($phone);
        } else {
            // Ensure records exist in user_agent_products
            foreach ($products as $amt) {
                $stmtCheck = $conn->prepare("SELECT id FROM user_agent_products WHERE user_id = ? AND product_amount = ?");
                $stmtCheck->execute([$user['id'], $amt]);
                if (!$stmtCheck->fetch()) {
                    $stmtInsert = $conn->prepare("INSERT INTO user_agent_products (user_id, product_amount, unlocked) VALUES (?, ?, 0)");
                    $stmtInsert->execute([$user['id'], $amt]);
                }
            }
        }
    }

    if (isset($_POST['toggle_unlock'])) {
        $userId = (int)$_POST['user_id'];
        $amount = (float)$_POST['amount'];
        $newStatus = (int)$_POST['new_status'];

        $stmt = $conn->prepare("UPDATE user_agent_products SET unlocked = ? WHERE user_id = ? AND product_amount = ?");
        $stmt->execute([$newStatus, $userId, $amount]);

        $message = $newStatus ? "✅ $amount USDT product unlocked for user." : "🔒 $amount USDT product locked for user.";

        // Reload user
        $stmt = $conn->prepare("SELECT id, phone FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}

// If user loaded, fetch product unlocks
$userProducts = [];
if ($user) {
    $stmt = $conn->prepare("SELECT product_amount, unlocked FROM user_agent_products WHERE user_id = ?");
    $stmt->execute([$user['id']]);
    $userProducts = $stmt->fetchAll(PDO::FETCH_KEY_PAIR); // [amount => unlocked]
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin - Unlock VIP Products</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      background: #111;
      color: #fff;
      font-family: Arial, sans-serif;
      padding: 20px;
    }
    .box {
      background: #222;
      padding: 20px;
      border-radius: 12px;
      max-width: 600px;
      margin: auto;
    }
    input, button {
      padding: 10px;
      border-radius: 8px;
      border: none;
      margin-top: 10px;
      width: 100%;
      font-size: 16px;
    }
    input { background: #333; color: #fff; }
    button { background: #28a745; color: #fff; cursor: pointer; }
    button.lock { background: #dc3545; }
    .msg { margin: 15px 0; font-weight: bold; }
    .product-row {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 8px;
      border-bottom: 1px solid #444;
    }
  </style>
</head>
<body>
  <div class="box">
    <h2>🔑 Unlock VIP Products ($300+)</h2>

    <?php if ($message): ?>
      <div class="msg"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="POST">
      <label>Search User by Phone:</label>
      <input type="text" name="search_phone" placeholder="Enter phone number" required>
      <button type="submit">Search</button>
    </form>

    <?php if ($user): ?>
      <hr>
      <h3>User Found:</h3>
      <p><b>ID:</b> <?= htmlspecialchars($user['id']) ?></p>
      <p><b>Phone:</b> <?= htmlspecialchars($user['phone']) ?></p>

      <h3>Product Unlocks:</h3>
      <?php foreach ($products as $amt): 
        $isUnlocked = isset($userProducts[$amt]) ? $userProducts[$amt] : 0;
      ?>
        <div class="product-row">
          <span><?= $amt ?> USDT Product</span>
          <form method="POST" style="margin:0;">
            <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
            <input type="hidden" name="amount" value="<?= $amt ?>">
            <input type="hidden" name="new_status" value="<?= $isUnlocked ? 0 : 1 ?>">
            <button type="submit" name="toggle_unlock" class="<?= $isUnlocked ? 'lock' : '' ?>">
              <?= $isUnlocked ? "Lock" : "Unlock" ?>
            </button>
          </form>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
</body>
</html>