<?php
include 'admin_db.php';

// Process AJAX actions
if (isset($_POST['action']) && isset($_POST['id'])) {
    $id = intval($_POST['id']);
    $action = $_POST['action'];

    if (in_array($action, ['manual', 'reject', 'kbpay'])) {
        $status = $action === 'reject' ? 'rejected' : 'approved';

        $stmt = $conn->prepare("UPDATE withdrawals SET status = :status WHERE id = :id");
        $stmt->execute([':status' => $status, ':id' => $id]);

        echo json_encode(['success' => true, 'status' => ucfirst($status)]);
        exit;
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid action']);
        exit;
    }
}

// Fetch withdrawals
$statusFilter = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';

$sql = "SELECT w.*, u.phone, u.flexible_wallet 
        FROM withdrawals w 
        LEFT JOIN users u ON u.id = w.user_id 
        WHERE 1=1";

$params = [];
if ($statusFilter && in_array($statusFilter, ['pending', 'approved', 'rejected'])) {
    $sql .= " AND w.status = :status";
    $params[':status'] = $statusFilter;
}
if ($search) {
    $sql .= " AND (u.phone LIKE :search OR w.usdt_wallet LIKE :search 
                   OR w.bank_account_number LIKE :search 
                   OR w.bank_account_name LIKE :search)";
    $params[':search'] = "%$search%";
}
$sql .= " ORDER BY w.created_at DESC";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Withdrawals Management</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <style>
    body {
      font-family: 'Inter', sans-serif;
      margin: 0;
      padding: 20px;
      background: #f5f6fa;
      color: #333;
    }
    h2 { margin-bottom: 20px; color: #222; }
    .toolbar {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 15px;
      flex-wrap: wrap;
    }
    .filters a {
      text-decoration: none;
      padding: 8px 14px;
      border-radius: 6px;
      margin-right: 8px;
      font-size: 13px;
      font-weight: 600;
      background: #f1f2f6;
      color: #333;
    }
    .filters a.active { background: #007bff; color: #fff; }
    .search-box input {
      padding: 8px 12px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 14px;
    }
    .card {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.08);
      padding: 20px;
      overflow-x: auto;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      font-size: 14px;
    }
    th, td {
      text-align: left;
      padding: 12px 10px;
      vertical-align: top;
    }
    th {
      background: #f1f2f6;
      font-weight: 600;
      position: sticky;
      top: 0;
      z-index: 2;
    }
    tr:nth-child(even) { background: #fafafa; }
    .status {
      padding: 6px 12px;
      border-radius: 8px;
      font-size: 12px;
      font-weight: 600;
      display: inline-block;
    }
    .status.pending { background: #fff3cd; color: #856404; }
    .status.approved { background: #d4edda; color: #155724; }
    .status.rejected { background: #f8d7da; color: #721c24; }
    .actions button {
      border: none;
      padding: 6px 12px;
      border-radius: 6px;
      margin-right: 6px;
      font-size: 12px;
      font-weight: 600;
      color: white;
      cursor: pointer;
    }
    .approve { background: #28a745; }
    .reject { background: #dc3545; }
    .manual { background: #007bff; }

    .copy-btn {
      background: #007bff;
      color: #fff;
      border: none;
      padding: 4px 8px;
      margin-left: 5px;
      border-radius: 5px;
      cursor: pointer;
      font-size: 12px;
    }
  </style>
</head>
<body>

<h2>Withdrawals Management</h2>

<div class="toolbar">
  <div class="filters">
    <a href="?status=" class="<?= $statusFilter==''?'active':'' ?>">All</a>
    <a href="?status=pending" class="<?= $statusFilter=='pending'?'active':'' ?>">Pending</a>
    <a href="?status=approved" class="<?= $statusFilter=='approved'?'active':'' ?>">Approved</a>
    <a href="?status=rejected" class="<?= $statusFilter=='rejected'?'active':'' ?>">Rejected</a>
  </div>
  <div class="search-box">
    <form method="get">
      <input type="hidden" name="status" value="<?= htmlspecialchars($statusFilter) ?>">
      <input type="text" name="search" placeholder="Search phone or wallet" value="<?= htmlspecialchars($search) ?>">
      <button type="submit">Search</button>
    </form>
  </div>
</div>

<div class="card">
  <table>
    <thead>
      <tr>
        <th>ID</th>
        <th>User Phone</th>
        <th>User Balance</th>
        <th>Type</th>
        <th>Amount</th>
        <th>Fee</th>
        <th>Net Amount</th>
        <th>Wallet / Bank Info</th>
        <th>Status</th>
        <th>Date & Time</th> <!-- ✅ Added -->
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($rows as $row): ?>
        <tr id="row-<?= $row['id'] ?>">
          <td><?= $row['id'] ?></td>
          <td><?= htmlspecialchars($row['phone']) ?></td>
          <td><?= number_format($row['flexible_wallet'], 2) ?> USDT</td>
          <td><?= strtoupper($row['type']) ?></td>
          <td>
            <?= number_format($row['amount'], 2) ?> USDT
            <button class="copy-btn" onclick="copyText('<?= $row['amount'] ?>')">Copy</button>
          </td>
          <td><?= number_format($row['fee'], 2) ?> USDT</td>
          <td><strong><?= number_format($row['net_amount'], 2) ?> USDT</strong></td>
          <td>
            <?php if (strtolower($row['type']) === 'usdt'): ?>
              <strong>Wallet:</strong> 
              <?= htmlspecialchars($row['usdt_wallet'] ?? $row['address'] ?? '') ?>
              <button class="copy-btn" onclick="copyText('<?= htmlspecialchars($row['usdt_wallet'] ?? $row['address'] ?? '') ?>')">Copy</button>
            <?php else: ?>
              <strong>Bank:</strong> <?= htmlspecialchars($row['bank_name'] ?? '') ?><br>
              <strong>Acc Name:</strong> <?= htmlspecialchars($row['bank_account_name'] ?? '') ?><br>
              <strong>Acc No:</strong> <?= htmlspecialchars($row['bank_account_number'] ?? '') ?>
              <button class="copy-btn" onclick="copyText('<?= htmlspecialchars($row['bank_account_number'] ?? '') ?>')">Copy</button>
            <?php endif; ?>
          </td>
          <td>
            <span class="status <?= strtolower($row['status']) ?>" id="status-<?= $row['id'] ?>">
              <?= ucfirst($row['status']) ?>
            </span>
          </td>

          <!-- ✅ Date & Time column -->
          <td>
            <?= date("Y-m-d H:i:s", strtotime($row['created_at'])) ?>
          </td>

          <td class="actions">
            <?php if ($row['status'] === 'pending'): ?>
              <button class="manual" onclick="updateWithdrawal(<?= $row['id'] ?>, 'manual')">Manual</button>
              <?php if ($row['type'] === 'bank'): ?>
                <button class="approve" onclick="updateWithdrawal(<?= $row['id'] ?>, 'kbpay')">KBPay</button>
              <?php endif; ?>
              <button class="reject" onclick="updateWithdrawal(<?= $row['id'] ?>, 'reject')">Reject</button>
            <?php else: ?>
              <?= ucfirst($row['status']) ?>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>


<script>
function copyText(text) {
  navigator.clipboard.writeText(text).then(() => {
    Swal.fire({
      icon: 'success',
      title: 'Copied!',
      text: text,
      timer: 1500,
      showConfirmButton: false
    });
  });
}

function updateWithdrawal(id, action) {
  fetch("", {
    method: "POST",
    headers: {"Content-Type": "application/x-www-form-urlencoded"},
    body: "id=" + id + "&action=" + action
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
      document.getElementById("status-" + id).innerText = data.status;
      document.getElementById("status-" + id).className = "status " + data.status.toLowerCase();
      document.querySelector("#row-" + id + " .actions").innerHTML = data.status;
      Swal.fire({
        icon: 'success',
        title: 'Updated',
        text: 'Withdrawal ' + data.status,
        timer: 2000,
        showConfirmButton: false
      });
    } else {
      Swal.fire({icon: 'error', title: 'Error', text: data.error});
    }
  });
}
</script>

</body>
</html>