<?php
session_start();
include 'admin_db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

$search = $_GET['search'] ?? '';
$message = '';

// ✅ Handle user update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_user'])) {
    $phone = $_POST['phone'];
    $electronic_wallet = floatval($_POST['electronic_wallet']);
    $flexible_wallet = floatval($_POST['flexible_wallet']);
    $newPassword = trim($_POST['password']);

    if (!empty($newPassword)) {
        $hashed = password_hash($newPassword, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET electronic_wallet = ?, flexible_wallet = ?, password = ? WHERE phone = ?");
        $stmt->execute([$electronic_wallet, $flexible_wallet, $hashed, $phone]);
    } else {
        $stmt = $conn->prepare("UPDATE users SET electronic_wallet = ?, flexible_wallet = ? WHERE phone = ?");
        $stmt->execute([$electronic_wallet, $flexible_wallet, $phone]);
    }

    $message = 'User updated successfully!';
}

// ✅ Handle Ban / Unban
if (isset($_GET['ban']) || isset($_GET['unban'])) {
    $phone = $_GET['ban'] ?? $_GET['unban'];
    $status = isset($_GET['ban']) ? 1 : 0;
    $stmt = $conn->prepare("UPDATE users SET is_banned = ? WHERE phone = ?");
    $stmt->execute([$status, $phone]);
    header("Location: admin_users.php?search=$phone");
    exit();
}

// ✅ Search
$query = "SELECT * FROM users";
$params = [];

if (!empty($search)) {
    $query .= " WHERE phone LIKE ? OR id LIKE ?";
    $params = ["%$search%", "%$search%"];
}

$stmt = $conn->prepare($query);
$stmt->execute($params);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin - User Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            background: #f0f0f0; 
            padding: 20px; 
            font-size: 18px;
        }
        h2 { font-size: 18px; color: maroon; margin-bottom: 20px; }
        .card { 
            background: #fff; 
            padding: 15px; 
            border-radius: 15px; 
            margin-bottom: 20px; 
            box-shadow: 0 4px 10px rgba(0,0,0,0.1); 
        }
        .card h3 { font-size: 18px; margin-top: 0; color: #333; }
        .input-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; font-size: 16px; }
        input[type="text"], input[type="number"], input[type="password"] { 
            width: 100%; 
            padding: 12px; 
            border: 2px solid #ccc; 
            border-radius: 8px; 
            font-size: 16px; 
            font-family: monospace;
        }
        button { 
            padding: 10px 18px; 
            border: none; 
            border-radius: 8px; 
            background: maroon; 
            color: #fff; 
            cursor: pointer; 
            font-size: 14px;
            font-weight: bold;
        }
        button:hover { opacity: 0.8; }
        .actions { display: flex; gap: 15px; margin-top: 15px; flex-wrap: wrap; }
        .search-box { margin-bottom: 25px; }
        .search-box input { 
            width: 250px; 
            padding: 10px; 
            border-radius: 8px; 
            border: 2px solid #ccc; 
            font-size: 14px; 
        }
        .search-box button { font-size: 14px; padding: 10px 20px; }
        .ban-btn { background: crimson; }
        .unban-btn { background: green; }
        .info { margin: 10px 0; font-size: 16px; }
        .highlight { font-weight: bold; color: maroon; }
    </style>
</head>
<body>
<h2>📋 User Management</h2>

<div class="search-box">
    <form method="get">
        <input type="text" name="search" placeholder="🔍 Search by phone or ID..." value="<?= htmlspecialchars($search ?? '') ?>">
        <button type="submit">Search</button>
    </form>
</div>

<?php foreach ($users as $user): ?>
    <?php
    // --- Invited By Lookup ---
    $invitedBy = "None";
    if (!empty($user['invited_by']) && $user['invited_by'] != "0" && $user['invited_by'] != "00") {
        $stmtRef = $conn->prepare("SELECT phone, invite_code FROM users WHERE invite_code = ?");
        $stmtRef->execute([$user['invited_by']]);
        $ref = $stmtRef->fetch(PDO::FETCH_ASSOC);

        if ($ref) {
            $invitedBy = "📱 " . htmlspecialchars($ref['phone']) . " | 🎟️ " . htmlspecialchars($ref['invite_code']);
        }
    }

    // --- Referral Counts ---
    $stmtTotalRefs = $conn->prepare("SELECT COUNT(*) FROM users WHERE invited_by = ?");
    $stmtTotalRefs->execute([$user['invite_code']]);
    $totalRefs = $stmtTotalRefs->fetchColumn();

    // ✅ Fixed: Replaced vip_level with s_level (actual column)
    // If s_level stores 'VIP0', 'VIP1', etc.
    $stmtVipRefs = $conn->prepare("SELECT COUNT(*) FROM users WHERE invited_by = ? AND s_level != 'VIP0'");
    $stmtVipRefs->execute([$user['invite_code']]);
    $vipRefs = $stmtVipRefs->fetchColumn();
    ?>

    <div class="card">
        <h3>👤 <?= htmlspecialchars($user['username']) ?> (<?= htmlspecialchars($user['phone']) ?>)</h3>
        <p>User ID: <span class="highlight"><?= htmlspecialchars($user['id']) ?></span></p>
        <p class="info">💰 Electronic Wallet: <span class="highlight"><?= $user['electronic_wallet'] ?> NLC</span></p>
        <p class="info">💼 Flexible Wallet: <span class="highlight"><?= $user['flexible_wallet'] ?> NLC</span></p>
        <p class="info">🚀 Status: <span class="highlight"><?= $user['is_banned'] ? '❌ Banned' : '✅ Active' ?></span></p>
        <p class="info">🎟️ Invite Code: <span class="highlight"><?= htmlspecialchars($user['invite_code'] ?? 'N/A') ?></span></p>
        <p class="info">🙋 Invited By: <span class="highlight"><?= $invitedBy ?></span></p>
        <p class="info">👥 Total Referrals: <span class="highlight"><?= $totalRefs ?></span></p>
        <p class="info">⭐ VIP1+ Referrals: <span class="highlight"><?= $vipRefs ?></span></p>

        <form method="post">
            <input type="hidden" name="phone" value="<?= htmlspecialchars($user['phone']) ?>">
            <div class="input-group">
                <label>Electronic Wallet</label>
                <input type="number" name="electronic_wallet" step="0.01" value="<?= $user['electronic_wallet'] ?>">
            </div>
            <div class="input-group">
                <label>Flexible Wallet</label>
                <input type="number" name="flexible_wallet" step="0.01" value="<?= $user['flexible_wallet'] ?>">
            </div>
            <div class="input-group">
                <label>New Password (leave blank if no change)</label>
                <input type="text" name="password" value="">
            </div>
            <div class="actions">
                <button type="submit" name="update_user">💾 Update</button>
                <a href="admin_users.php?<?= $user['is_banned'] ? 'unban' : 'ban' ?>=<?= urlencode($user['phone']) ?>">
                    <button type="button" class="<?= $user['is_banned'] ? 'unban-btn' : 'ban-btn' ?>">
                        <?= $user['is_banned'] ? '🔓 Unban' : '🚫 Ban' ?>
                    </button>
                </a>
                <a href="login_as_user.php?phone=<?= urlencode($user['phone']) ?>">
                    <button type="button">🔑 Login as User</button>
                </a>
            </div>
        </form>
    </div>
<?php endforeach; ?>

<?php if ($message): ?>
<script>
Swal.fire({
    icon: 'success',
    title: '✅ Success',
    text: '<?= $message ?>',
    confirmButtonColor: '#800000'
});
</script>
<?php endif; ?>
</body>
</html>