<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

require 'admin_db.php';

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'];

    if (isset($_FILES['video']) && $_FILES['video']['error'] === 0) {
        $targetDir = "../uploads/videos/";
        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0755, true);
        }

        $fileName = time() . "_" . basename($_FILES["video"]["name"]);
        $targetFile = $targetDir . $fileName;
        $fileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));

        $allowed = ['mp4', 'webm', 'ogg'];

        if (in_array($fileType, $allowed)) {
            if (move_uploaded_file($_FILES["video"]["tmp_name"], $targetFile)) {
                $stmt = $conn->prepare("INSERT INTO videos (title, file_path) VALUES (?, ?)");
                $stmt->execute([$title, $targetFile]);
                $message = "<p style='color:green;'>✅ Video uploaded successfully!</p>";
            } else {
                $message = "<p style='color:red;'>❌ Failed to upload video.</p>";
            }
        } else {
            $message = "<p style='color:red;'>❌ Invalid file format. Allowed: mp4, webm, ogg.</p>";
        }
    } else {
        $message = "<p style='color:red;'>❌ No video selected.</p>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Upload Video</title>
    <style>
        body { background: #111; color: white; font-family: Arial; padding: 30px; }
        .form-box {
            max-width: 400px; margin: auto; padding: 20px;
            background: #222; border-radius: 8px;
        }
        input, button {
            width: 100%; margin-top: 10px; padding: 10px;
            border: none; border-radius: 4px;
        }
        input { background: #333; color: white; }
        button { background: #800000; color: white; cursor: pointer; }
    </style>
</head>
<body>
    <div class="form-box">
        <h2>Upload New Video</h2>
        <?= $message ?>
        <form method="post" enctype="multipart/form-data">
            <input type="text" name="title" placeholder="Video Title" required />
            <input type="file" name="video" accept="video/*" required />
            <button type="submit">Upload Video</button>
        </form>
    </div>
</body>
</html>