<?php  
// admin_recharges.php  
session_start();  
include 'admin_db.php';  

// Fetch pending recharges  
$stmt = $conn->prepare("SELECT * FROM recharge_records WHERE status = 'pending' ORDER BY created_at DESC");  
$stmt->execute();  
$recharges = $stmt->fetchAll(PDO::FETCH_ASSOC);  
?>  

<!DOCTYPE html>  
<html lang="en">  
<head>  
  <meta charset="UTF-8">  
  <title>Pending Recharges</title>  
  <script src="https://cdn.tailwindcss.com"></script>  
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>  
</head>  
<body class="bg-gray-100 p-6">  
  <div class="max-w-6xl mx-auto bg-white rounded-xl shadow-lg p-6">  
    <h2 class="text-2xl font-bold mb-4 text-gray-800">Pending Recharge Requests</h2>  

    <!-- 🔍 Search Bar -->  
    <div class="mb-4">  
      <input id="searchInput"  
             type="text"  
             placeholder="Search by phone or amount..."  
             class="w-full border rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-400">  
    </div>  

    <div class="overflow-x-auto">  
      <table class="w-full table-auto text-sm border-collapse">  
        <thead class="bg-gray-200 text-gray-700">  
          <tr>  
            <th class="border p-2">Phone</th>  
            <th class="border p-2">Amount</th>  
            <th class="border p-2">Date</th>  
            <th class="border p-2">Receipt</th>  
            <th class="border p-2">Action</th>  
          </tr>  
        </thead>  
        <tbody id="rechargeTable">  
          <?php foreach ($recharges as $r): ?>  
            <tr class="text-center hover:bg-gray-50 transition">  
              <td class="border p-2"><?= htmlspecialchars($r['phone'] ?? '') ?></td>  
              <td class="border p-2 font-semibold text-green-600">$<?= number_format($r['amount'], 2) ?></td>  
              <td class="border p-2"><?= date('m/d/Y H:i:s', strtotime($r['created_at'])) ?></td>  
              <td class="border p-2">  
                <?php if (!empty($r['receipt'])): ?>  
                  <?php $receiptPath = '../../' . ltrim($r['receipt'], '/'); ?>  
                  <?php if (preg_match('/\.(jpg|jpeg|png|gif)$/i', $r['receipt'])): ?>  
                    <a href="<?= htmlspecialchars($receiptPath) ?>" target="_blank">  
                      <img src="<?= htmlspecialchars($receiptPath) ?>"  
                           class="max-w-[80px] max-h-[80px] rounded shadow">  
                    </a>  
                  <?php elseif (preg_match('/\.pdf$/i', $r['receipt'])): ?>  
                    <a href="<?= htmlspecialchars($receiptPath) ?>" target="_blank" class="text-blue-500 underline">View PDF</a>  
                  <?php else: ?>  
                    <a href="<?= htmlspecialchars($receiptPath) ?>" target="_blank" class="text-blue-500 underline">View File</a>  
                  <?php endif; ?>  
                <?php else: ?>  
                  <span class="text-red-500">No Receipt</span>  
                <?php endif; ?>  
              </td>  
              <td class="border p-2 space-x-2">  
                <button onclick="approveRecharge(<?= (int)$r['id'] ?>)"  
                        class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600">Approve</button>  
                <button onclick="rejectRecharge(<?= (int)$r['id'] ?>)"  
                        class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600">Reject</button>  
              </td>  
            </tr>  
          <?php endforeach; ?>  
        </tbody>  
      </table>  
    </div>  

    <?php if (empty($recharges)): ?>  
      <p class="text-gray-500 text-center mt-6">No pending recharges.</p>  
    <?php endif; ?>  
  </div>  

  <script>  
  // 🔍 Live Search  
  document.getElementById('searchInput').addEventListener('keyup', function() {  
      let filter = this.value.toLowerCase();  
      let rows = document.querySelectorAll("#rechargeTable tr");  
      rows.forEach(row => {  
          let text = row.textContent.toLowerCase();  
          row.style.display = text.includes(filter) ? "" : "none";  
      });  
  });  

  // ✅ Approve  
  function approveRecharge(id) {  
      Swal.fire({  
          title: 'Approve this recharge?',  
          text: "The amount will be credited to the user's wallet.",  
          icon: 'success',  
          showCancelButton: true,  
          confirmButtonColor: '#28a745',  
          cancelButtonColor: '#d33',  
          confirmButtonText: 'Yes, approve it!'  
      }).then((result) => {  
          if (result.isConfirmed) {  
              window.location.href = 'approve_recharge.php?id=' + id;  
          }  
      });  
  }  

  // ❌ Reject  
  function rejectRecharge(id) {  
      Swal.fire({  
          title: 'Reject this recharge?',  
          text: "This action cannot be undone.",  
          icon: 'warning',  
          showCancelButton: true,  
          confirmButtonColor: '#d33',  
          cancelButtonColor: '#3085d6',  
          confirmButtonText: 'Yes, reject it!'  
      }).then((result) => {  
          if (result.isConfirmed) {  
              window.location.href = 'reject_recharge.php?id=' + id;  
          }  
      });  
  }  
  </script>  
</body>  
</html>