<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

if (empty($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

include 'admin_db.php';

// --- Handle filters & search ---
$status_filter = $_GET['status'] ?? 'pending'; // default = pending
$search = $_GET['search'] ?? '';

// --- Handle approve/reject actions ---
$popup_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $record_id = intval($_POST['record_id']);
    $action = $_POST['action'];

    $stmt = $conn->prepare("SELECT * FROM recharge_records WHERE id = ?");
    $stmt->execute([$record_id]);
    $record = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($record) {
        if ($action === 'approve') {
            if ($record['status'] === 'pending') {
                $conn->prepare("UPDATE recharge_records SET status='success' WHERE id=?")
                     ->execute([$record_id]);
                $conn->prepare("UPDATE users SET electronic_wallet = electronic_wallet + ? WHERE phone=?")
                     ->execute([$record['amount'], $record['phone']]);
                $popup_message = "Approved successfully!";
            } else {
                $popup_message = "Already processed!";
            }
        } elseif ($action === 'reject') {
            if ($record['status'] === 'pending') {
                $conn->prepare("UPDATE recharge_records SET status='rejected' WHERE id=?")
                     ->execute([$record_id]);
                $popup_message = "Rejected successfully!";
            } else {
                $popup_message = "Already processed!";
            }
        }
    }
}

// --- Fetch deposits based on filter/search ---
// Exclude users ID 242, 253 944 914 311 274 and 263
$query = "SELECT r.* 
          FROM recharge_records r
          LEFT JOIN users u ON r.phone = u.phone
          WHERE u.id NOT IN (242, 253, 944, 914, 311, 274, 263 )";
$params = [];

if ($status_filter !== 'all') {
    $query .= " AND r.status = ?";
    $params[] = $status_filter;
}
if (!empty($search)) {
    $query .= " AND (r.phone LIKE ? OR r.name LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}
$query .= " ORDER BY r.id DESC";

$stmt = $conn->prepare($query);
$stmt->execute($params);
$deposits = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin - Deposits</title>
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-900 text-white font-sans p-6">

<h1 class="text-2xl font-bold mb-6 text-yellow-400">Deposit Records</h1>

<!-- Filters & Search -->
<form method="GET" class="flex gap-3 mb-6">
    <select name="status" class="px-3 py-2 rounded bg-gray-800 border border-gray-600">
        <option value="all" <?= $status_filter==='all'?'selected':'' ?>>All</option>
        <option value="pending" <?= $status_filter==='pending'?'selected':'' ?>>Pending</option>
        <option value="success" <?= $status_filter==='success'?'selected':'' ?>>Approved</option>
        <option value="rejected" <?= $status_filter==='rejected'?'selected':'' ?>>Rejected</option>
    </select>
    <input type="text" name="search" placeholder="Search by name/phone" value="<?= htmlspecialchars($search) ?>" 
           class="px-3 py-2 rounded bg-gray-800 border border-gray-600 flex-1">
    <button type="submit" class="bg-yellow-500 text-gray-900 font-bold px-4 rounded">Filter</button>
</form>

<!-- Deposit Cards -->
<div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
<?php foreach($deposits as $index => $d): ?>
  <div class="bg-gray-800 rounded-lg shadow-lg p-5">
    <div class="flex justify-between items-center mb-3">
      <h2 class="text-lg font-bold text-yellow-400">#<?= $index+1 ?> — <?= htmlspecialchars($d['name'] ?? '-') ?></h2>
      <?php if($d['status']==='pending'): ?>
        <span class="bg-yellow-500 text-gray-900 text-xs px-2 py-1 rounded">Pending</span>
      <?php elseif($d['status']==='success'): ?>
        <span class="bg-green-500 text-gray-900 text-xs px-2 py-1 rounded">Approved</span>
      <?php else: ?>
        <span class="bg-red-500 text-gray-900 text-xs px-2 py-1 rounded">Rejected</span>
      <?php endif; ?>
    </div>

    <p><strong>Phone:</strong> <?= htmlspecialchars($d['phone'] ?? '-') ?></p>
    <p><strong>Amount:</strong> <?= number_format($d['amount'] ?? 0, 2) ?> USDT</p>
    <p><strong>Method:</strong> <?= htmlspecialchars($d['payment_method'] ?? '-') ?></p>
    <p><strong>Network:</strong> <?= htmlspecialchars($d['network'] ?? '-') ?></p>
    <p><strong>Wallet:</strong> <?= htmlspecialchars($d['wallet'] ?? '-') ?></p>
    <p><strong>TXID:</strong> <?= htmlspecialchars($d['txid'] ?? '-') ?></p>
    <p><strong>Date:</strong> <?= !empty($d['created_at']) ? date('m/d/Y H:i', strtotime($d['created_at'])) : '-' ?></p>

    <?php if(!empty($d['receipt']) && file_exists($d['receipt'])): ?>
      <div class="mt-3">
        <?php $ext = pathinfo($d['receipt'], PATHINFO_EXTENSION); ?>
        <?php if(in_array(strtolower($ext), ['jpg','jpeg','png'])): ?>
          <img src="<?= htmlspecialchars($d['receipt']) ?>" class="rounded-lg max-h-40">
        <?php elseif(strtolower($ext) === 'pdf'): ?>
          <a href="<?= htmlspecialchars($d['receipt']) ?>" target="_blank" class="text-blue-400 underline">View PDF Receipt</a>
        <?php endif; ?>
      </div>
    <?php endif; ?>

    <!-- Actions -->
    <?php if($d['status']==='pending'): ?>
      <div class="flex gap-3 mt-4">
        <form method="POST" class="flex-1">
          <input type="hidden" name="record_id" value="<?= $d['id'] ?>">
          <button name="action" value="approve" class="w-full bg-green-500 hover:bg-green-600 text-gray-900 font-bold py-2 rounded">Approve</button>
        </form>
        <form method="POST" class="flex-1">
          <input type="hidden" name="record_id" value="<?= $d['id'] ?>">
          <button name="action" value="reject" class="w-full bg-red-500 hover:bg-red-600 text-gray-900 font-bold py-2 rounded">Reject</button>
        </form>
      </div>
    <?php endif; ?>
  </div>
<?php endforeach; ?>

<?php if(empty($deposits)): ?>
  <p class="text-gray-400 col-span-full text-center">No records found</p>
<?php endif; ?>
</div>

<?php if(!empty($popup_message)): ?>
<script>
Swal.fire({
  icon: 'success',
  title: 'Done',
  text: '<?= $popup_message ?>',
  confirmButtonColor: '#3085d6'
}).then(() => {
  window.location.href = window.location.href; // reload
});
</script>
<?php endif; ?>

</body>
</html>