<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include 'admin_db.php'; // Adjust this path if needed

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

function generateGiftCode($length = 24) {
    return strtoupper(substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, $length));
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $code = generateGiftCode();
    $reward_amount = isset($_POST['amount']) ? floatval($_POST['amount']) : 0;
    $max_claims = isset($_POST['limit']) ? intval($_POST['limit']) : 1;
    $expires_at = !empty($_POST['expires']) ? $_POST['expires'] : null;

    $stmt = $conn->prepare("INSERT INTO gift_codes (code, reward_amount, max_claims, expires_at) VALUES (?, ?, ?, ?)");
    $stmt->execute([$code, $reward_amount, $max_claims, $expires_at]);
    $success = "✅ Gift code created: $code";
}

// Fetch all codes
$codes = $conn->query("SELECT * FROM gift_codes ORDER BY created_at DESC")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Gift Codes</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f4f9; padding: 20px; }
        .form, .table { background: #fff; padding: 20px; border-radius: 15px; margin-bottom: 30px; box-shadow: 0 5px 20px rgba(0,0,0,0.1); }
        input, button { padding: 8px; margin: 5px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 12px; border-bottom: 1px solid #ddd; text-align: center; }
        th { background: #007bff; color: white; }
    </style>
</head>
<body>
    <div class="form">
        <h2>🎁 Generate Gift Code</h2>
        <?php if (isset($success)) echo "<p style='color:green'>$success</p>"; ?>
        <form method="POST">
            <input type="number" step="0.01" name="amount" placeholder="Amount (USDT)" required>
            <input type="number" name="limit" placeholder="Usage Limit" value="1" required>
            <input type="datetime-local" name="expires">
            <button type="submit">Generate</button>
        </form>
    </div>

    <div class="table">
        <h2>📋 Gift Codes</h2>
        <table>
            <tr>
                <th>Code</th>
                <th>Reward Amount</th>
                <th>Max Claims</th>
                <th>Claimed</th>
                <th>Expires At</th>
            </tr>
            <?php foreach ($codes as $c): ?>
            <tr>
                <td><?php echo htmlspecialchars($c['code']); ?></td>
                <td><?php echo htmlspecialchars($c['reward_amount']); ?> USDT</td>
                <td><?php echo htmlspecialchars($c['max_claims']); ?></td>
                <td><?php echo htmlspecialchars($c['claimed_count']); ?></td>
                <td><?php echo $c['expires_at'] ?: 'No Expiry'; ?></td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>