<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

include 'admin_db.php'; // ✅ Correct DB connection

$message = "";

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $amount = $_POST['amount'];
    $viewing_income = $_POST['viewing_income'];
    $daily_earning_limit = $_POST['daily_earning_limit'];
    $valid_days = $_POST['valid_days'];
    $referral_bonus = $_POST['referral_reward']; // ✅ Correct field name
    $is_agent_only = isset($_POST['is_agent_only']) ? 1 : 0;
    $status = $_POST['status'];

    // Handle image upload
    $img = "";
    if (isset($_FILES['img']) && $_FILES['img']['error'] === UPLOAD_ERR_OK) {
        $imgName = time() . '_' . basename($_FILES["img"]["name"]);
        $targetFile = "../uploads/" . $imgName;
        if (move_uploaded_file($_FILES["img"]["tmp_name"], $targetFile)) {
            $img = $imgName;
        }
    }

    // Insert into database
    $stmt = $conn->prepare("INSERT INTO vip_products 
        (name, amount, viewing_income, daily_earning_limit, valid_days, referral_bonus, is_agent_only, status, img) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    if ($stmt->execute([$name, $amount, $viewing_income, $daily_earning_limit, $valid_days, $referral_bonus, $is_agent_only, $status, $img])) {
        $message = "✅ Product added successfully!";
    } else {
        $message = "❌ Failed to add product.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add VIP Product</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        form {
            max-width: 400px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 10px;
        }
        label {
            font-weight: bold;
        }
        input, select, button {
            width: 100%;
            padding: 8px;
            margin-top: 5px;
            margin-bottom: 15px;
        }
        button {
            background: #2d78ff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background: #1a5edc;
        }
        .success {
            color: green;
        }
        .error {
            color: red;
        }
    </style>
</head>
<body>
    <h2>Add VIP Product</h2>

    <?php if ($message): ?>
        <p class="<?= strpos($message, '✅') !== false ? 'success' : 'error' ?>"><?= $message ?></p>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">
        <label>Product Name:</label>
        <input type="text" name="name" required>

        <label>Amount (USDT):</label>
        <input type="number" step="0.01" name="amount" required>

        <label>Viewing Income (USDT per video):</label>
        <input type="number" step="0.01" name="viewing_income" required>

        <label>Daily Earning Limit (number of videos):</label>
        <input type="number" name="daily_earning_limit" required>

        <label>Valid Days:</label>
        <input type="number" name="valid_days" required>

        <label>Referral Reward (USDT):</label> <!-- ✅ Fixed name -->
        <input type="number" step="0.01" name="referral_reward" required>

        <label>Agent Only:</label>
        <input type="checkbox" name="is_agent_only">

        <label>Status:</label>
        <select name="status" required>
            <option value="active">Active</option>
            <option value="coming_soon">Coming Soon</option>
        </select>

        <label>Upload Image:</label>
        <input type="file" name="img" accept="image/*">

        <button type="submit">Add VIP Product</button>
    </form>
</body>
</html>