<?php
session_start();
require_once 'admin_db.php';

if (!isset($_SESSION['admin_logged_in'])) {
  header("Location: login.php");
  exit();
}

$success = false;
$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'];
  $amount = $_POST['amount'];
  $viewing_income = $_POST['viewing_income'];
  $daily_earning_limit = $_POST['daily_earning_limit'];
  $valid_days = $_POST['valid_days'];
  $description = $_POST['description'];
  $status = $_POST['status']; // NEW
  $agent_only = isset($_POST['is_agent_only']) ? 1 : 0;
  $img = 'images/default.png';

  // Image upload
  if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
    $uploadDir = '../../images/vip/';
    $uploadFile = $uploadDir . basename($_FILES['image']['name']);
    if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadFile)) {
      $img = 'images/vip/' . basename($_FILES['image']['name']);
    }
  }

  $stmt = $conn->prepare("INSERT INTO vip_products (name, amount, viewing_income, daily_earning_limit, valid_days, description, agent_only, img, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
  $success = $stmt->execute([$name, $amount, $viewing_income, $daily_earning_limit, $valid_days, $description, $agent_only, $img, $status]);

  if ($success) {
    $vip_product_id = $conn->lastInsertId();
    $_SESSION['product_added'] = true;
    $_SESSION['new_vip_id'] = $vip_product_id;
    header("Location: dashboard.php?new_vip_id=$vip_product_id");
    exit();
  } else {
    $error = "Failed to add product.";
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Add VIP Product</title>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f5f5f5;
      padding: 20px;
    }
    .form-container {
      background: white;
      padding: 20px;
      max-width: 600px;
      margin: auto;
      border-radius: 10px;
      box-shadow: 0 0 10px #ccc;
    }
    .form-container input, .form-container textarea, .form-container select {
      width: 100%;
      padding: 10px;
      margin-top: 10px;
    }
    .form-container label {
      margin-top: 15px;
      display: block;
      font-weight: bold;
    }
    .form-container button {
      margin-top: 20px;
      padding: 10px;
      background: maroon;
      color: white;
      border: none;
      cursor: pointer;
      width: 100%;
    }
  </style>
</head>
<body>
  <div class="form-container">
    <h2>Add VIP Product</h2>
    <form method="POST" enctype="multipart/form-data">
      <label>Name</label>
      <input type="text" name="name" required>

      <label>Price (USDT)</label>
      <input type="number" name="amount" required>

      <label>Viewing Income (USDT)</label>
      <input type="number" step="0.01" name="viewing_income" required>

      <label>Daily Earning Limit</label>
      <input type="number" name="daily_earning_limit" required>

      <label>Valid Days</label>
      <input type="number" name="valid_days" required>

      <label>Description</label>
      <textarea name="description" rows="4" required></textarea>

      <label>Status</label>
      <select name="status" required>
        <option value="active">Active</option>
        <option value="inactive">Inactive</option>
      </select>

      <label>
        <input type="checkbox" name="is_agent_only"> Agent Only
      </label>

      <label>Product Image</label>
      <input type="file" name="image">

      <button type="submit">Add Product</button>
    </form>
  </div>

  <?php if ($error): ?>
    <script>
      Swal.fire('Error', '<?= $error ?>', 'error');
    </script>
  <?php endif; ?>
</body>
</html>