<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];
$success = $error = "";

// Fetch user info
$stmt = $conn->prepare("SELECT id, password FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$user_id = $user['id'];
$current_hashed_password = $user['password'];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $old_password = $_POST['old_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if (empty($old_password) || empty($new_password) || empty($confirm_password)) {
        $error = "All fields are required.";
    } elseif (!password_verify($old_password, $current_hashed_password)) {
        $error = "Old password is incorrect.";
    } elseif ($new_password !== $confirm_password) {
        $error = "New passwords do not match.";
    } elseif (strlen($new_password) < 6) {
        $error = "New password must be at least 6 characters.";
    } else {
        $hashed_new = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt->execute([$hashed_new, $user_id]);
        $success = "Password updated successfully!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Change Password</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <style>
        * { box-sizing: border-box; font-family: Arial, sans-serif; }
        body {
            margin: 0;
            padding: 0;
            background-color: #000;
            color: #fff;
        }
        form {
            background-color: #111;
            padding: 25px;
            max-width: 400px;
            margin: 60px auto;
            border-radius: 12px;
            box-shadow: 0 0 10px #333;
        }
        h2 {
            text-align: center;
            margin-bottom: 25px;
            color: #fff;
        }
        input {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border: 1px solid #444;
            border-radius: 6px;
            background-color: #222;
            color: #fff;
        }
        button {
            width: 100%;
            padding: 12px;
            background-color: #00cc66;
            border: none;
            border-radius: 6px;
            font-weight: bold;
            color: #000;
            cursor: pointer;
        }
        button:hover {
            background-color: #00e676;
        }
        .message {
            text-align: center;
            margin-top: 15px;
        }
        .error {
            color: #ff3333;
        }
        .success {
            color: #00cc66;
        }
    </style>
</head>
<body>

<form method="post">
    <h2>Change Password</h2>

    <input type="password" name="old_password" placeholder="Current Password" required>
    <input type="password" name="new_password" placeholder="New Password" required>
    <input type="password" name="confirm_password" placeholder="Confirm New Password" required>

    <button type="submit">Update Password</button>

    <div class="message">
        <?php if ($error): ?><div class="error"><?= $error ?></div><?php endif; ?>
        <?php if ($success): ?><div class="success"><?= $success ?></div><?php endif; ?>
    </div>
</form>

</body>
</html>