<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];
$stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$user_id = $user['id'];

$success = $error = "";

// Handle form submission (verify OTP + save password)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['otp'], $_POST['password'], $_POST['confirm']) && !isset($_POST['action'])) {
    $otp = $_POST['otp'];
    $password = $_POST['password'];
    $confirm = $_POST['confirm'];
    $email = $_SESSION['email'] ?? null;

    if ($password !== $confirm) {
        $error = "❌ Passwords do not match!";
    } elseif (strlen($password) != 6 || !ctype_digit($password)) {
        $error = "❌ Password must be a 6-digit number.";
    } elseif (!isset($_SESSION['otp']) || $_SESSION['otp'] != $otp) {
        $error = "❌ Invalid OTP!";
    } elseif (!isset($_SESSION['otp_expire']) || time() > $_SESSION['otp_expire']) {
        $error = "❌ OTP expired.";
    } elseif (!$email) {
        $error = "❌ No email bound.";
    } else {
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password = ?, email = ? WHERE id = ?");
        $stmt->execute([$hashed, $email, $user_id]);
        unset($_SESSION['otp'], $_SESSION['otp_expire'], $_SESSION['email']);
        $success = "✅ Password updated successfully.";
    }
}

// Handle OTP sending via AJAX
if (isset($_POST['action']) && $_POST['action'] == 'send_otp' && isset($_POST['email'])) {
    $email = $_POST['email'];
    $_SESSION['email'] = $email;
    $otp = rand(100000, 999999);
    $_SESSION['otp'] = $otp;
    $_SESSION['otp_expire'] = time() + 300;

    // SMTP config
    $smtpHost = "server174.web-hosting.com";
    $smtpUser = "nlc.newline-cinema.cc@nlc.newline-cinema.cc";
    $smtpPass = "Aa123456@Abdul11..";
    $smtpPort = 465;

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = $smtpHost;
        $mail->SMTPAuth = true;
        $mail->Username = $smtpUser;
        $mail->Password = $smtpPass;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = $smtpPort;

        $mail->setFrom($smtpUser, 'NLC OTP Service');
        $mail->addAddress($email);
        $mail->isHTML(true);
        $mail->Subject = "Your OTP Code";
        $mail->Body = "<h2>Your OTP is: <b>$otp</b></h2><p>Valid for 5 minutes.</p>";

        $mail->send();
        echo json_encode(['success' => true, 'msg' => "OTP sent to $email"]);
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => "❌ Failed to send OTP: {$mail->ErrorInfo}"]);
    }
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Change Login Password</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover"/>
  <style>
    html, body {
        margin:0;
        padding:0;
        height:100%;
        overflow:hidden; /* Prevent scrolling */
        background:#000;
        color:#fff;
        font-family:Arial,sans-serif;
    }
    .top-bar {
        height:50px;
        background:#111;
        display:flex;
        align-items:center;
        padding:0 16px;
        flex-shrink:0;
    }
    .top-bar a { color:#fff; font-size:15px; text-decoration:none; }
    .top-bar-title { flex:1; text-align:center; font-size:15px; font-weight:bold; }
    .container {
        padding:20px;
        height: calc(100% - 50px); /* fill remaining viewport */
        overflow:hidden;
        box-sizing:border-box;
        display:flex;
        flex-direction:column;
        justify-content:flex-start;
    }
    .form-group { margin-bottom:20px; flex-shrink:0; }
    .form-group label { font-size:14px; display:block; margin-bottom:8px; }
    .input-wrapper { position:relative; }
    input[type="email"], input[type="text"], input[type="password"] {
      width:100%;
      padding:14px 80px 14px 12px;
      border:none;
      border-radius:8px;
      background:#1c1c1c;
      color:#fff;
      font-size:16px;
    }
    .send-link {
        position:absolute;
        right:12px;
        top:50%;
        transform:translateY(-50%);
        background:none;
        border:none;
        color:#caa076;
        cursor:pointer;
        font-size:14px;
    }
    .reminder { font-size:12px; color:#ffc107; margin-top:10px; }
    .ok-button {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  padding: 14px;
  border: none;
  color: white;
  font-size: 14px;
  font-weight: bold;
  cursor: pointer;
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;
  /* Use gradient with your two colors */
  background: linear-gradient(to right, #85461E, #caa076);
}
    .message { font-size:14px; color:#caa076; margin-bottom:15px; }
    .toast {
        visibility:hidden;
        min-width:200px;
        background:#111;
        color:#fff;
        text-align:center;
        border-radius:6px;
        padding:12px;
        position:fixed;
        left:50%;
        top:30%;
        transform:translate(-50%, -50%);
        z-index:9999;
        opacity:0;
        transition:opacity 0.5s, top 0.5s;
    }
    .toast.show { visibility:visible; opacity:1; top:40%; }
  </style>
</head>
<body>
<div class="top-bar">
  <a href="dashboard.php">&#8592;</a>
  <div class="top-bar-title">Change Login Password</div>
</div>
<div class="container">
  <?php if ($error) echo "<div class='message'>$error</div>"; ?>
  <?php if ($success) echo "<div class='message'>$success</div>"; ?>
  <form method="post" id="passwordForm">
    <div class="form-group">
      <label>Email address</label>
      <input type="email" name="email" id="email" placeholder="Enter email" required>
    </div>
    <div class="form-group">
      <label>Verification Code</label>
      <div class="input-wrapper">
        <input type="text" name="otp" id="otp" placeholder="Enter verification code" required>
        <button type="button" class="send-link" onclick="sendOTP()">Send</button>
      </div>
    </div>
    <div class="form-group">
      <label>New Password</label>
      <input type="password" name="password" placeholder="6-digit combination" required>
    </div>
    <div class="form-group">
      <input type="password" name="confirm" placeholder="Confirm password" required>
    </div>
    <div class="reminder">⚠️ Your login password must be 6 digits.</div>
    <button type="submit" class="ok-button">submit</button>
  </form>
</div>

<div id="toast" class="toast"></div>

<script>
function showToast(msg) {
  const toast = document.getElementById("toast");
  toast.innerText = msg;
  toast.className = "toast show";
  setTimeout(() => toast.className = toast.className.replace("show",""), 2000);
}

function sendOTP() {
  const email = document.getElementById('email').value;
  if (!email) return showToast("Enter email first");

  fetch(window.location.pathname, {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: new URLSearchParams({ action: 'send_otp', email })
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
      showToast(data.msg);
      document.getElementById('email').readOnly = true;
    } else {
      showToast(data.error || 'Failed to send OTP');
    }
  })
  .catch(() => showToast("❌ Request failed"));
}
</script>
</body>
</html>