<?php 
  // Get the current file name (e.g., dashboard.php, mine.php, etc.)
  $current_page = basename($_SERVER['PHP_SELF']);
?>
<style>
  .bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #2E2E2E;
    display: flex;
    justify-content: space-around;
    align-items: center;
    height: 60px;
    z-index: 1000;
    box-shadow: 0 -2px 5px rgba(0,0,0,0.4);
    border-top: 1px solid #1c1c1c;
  }

  .bottom-nav a {
    text-decoration: none;
    color: #9b9b9b;
    font-size: 12px;
    display: flex;
    flex-direction: column;
    align-items: center;
    font-weight: 500;
    transition: color 0.3s ease;
  }

  .bottom-nav a i {
    font-size: 20px;
    margin-bottom: 4px;
  }

  .bottom-nav a.active {
    color: #f2c573;
  }

  .bottom-nav a.active i {
    background: linear-gradient(180deg, #f7d7a3 0%, #f4b56a 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }

  .nav-spacer {
    height: 65px;
    width: 100%;
  }
</style>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<div class="nav-spacer"></div>

<!-- ✅ Bottom Navigation -->
<div class="bottom-nav">
  <a href="dashboard.php" class="<?= $current_page == 'dashboard.php' ? 'active' : '' ?>">
    <i class="fas fa-chevron-up"></i>
    <span>Home</span>
  </a>
  <a href="promotion.php" class="<?= $current_page == 'promotion.php' ? 'active' : '' ?>">
    <i class="fas fa-gem"></i>
    <span>Team</span>
  </a>
  <a href="index.php" class="<?= $current_page == 'index.php' ? 'active' : '' ?>">
    <i class="fas fa-gift"></i>
    <span>Revenue</span>
  </a>
  <a href="task_record.php" class="<?= $current_page == 'task_record.php' ? 'active' : '' ?>">
    <i class="fas fa-file-alt"></i>
    <span>Record</span>
  </a>
  <a href="mine.php" class="<?= $current_page == 'mine.php' ? 'active' : '' ?>">
    <i class="fas fa-user"></i>
    <span>Mine</span>
  </a>
</div>