<?php
session_start();
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Load PHPMailer
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

// Handle AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {

    header('Content-Type: application/json');

    // === STEP 1: SEND OTP ===
    if ($_POST['action'] === "send_otp" && isset($_POST['email'])) {

        $user_email = trim($_POST['email']);
        $otp = rand(100000, 999999);

        $_SESSION['otp'] = $otp;
        $_SESSION['email'] = $user_email;
        $_SESSION['otp_expire'] = time() + 300; // 5 minutes

        $mail = new PHPMailer(true);

        try {
            $mail->isSMTP();
            $mail->Host = 'new-line-cinema.cc';
            $mail->SMTPAuth = true;
            $mail->Username = '_mainaccount@new-line-cinema.cc';
            $mail->Password = 'Abdul11..Aa123456@';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port = 465;

            $mail->SMTPOptions = [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true,
                ],
            ];

            $mail->setFrom('_mainaccount@new-line-cinema.cc', 'New Line Cinema');
            $mail->addAddress($user_email);
            $mail->isHTML(true);
            $mail->Subject = ' Your One-Time Password (OTP)';

            // === Stylish HTML Email Template ===
            $mail->Body = '
            <div style="background:#f7f7f7; padding:40px 0; font-family:Arial, sans-serif;">
                <div style="max-width:480px; margin:auto; background:#fff; border-radius:8px; box-shadow:0 0 8px rgba(0,0,0,0.1); overflow:hidden;">
                    <div style="background:linear-gradient(90deg,#85461E,#caa076); padding:20px; text-align:center; color:white;">
                        <h2 style="margin:0;">New Line Cinema</h2>
                        <p style="margin:5px 0 0; font-size:14px;">Secure Verification Code</p>
                    </div>
                    <div style="padding:30px; text-align:center; color:#333;">
                        <p style="font-size:16px;">Hello,</p>
                        <p style="font-size:15px; color:#666;">Use the following code to verify your email address:</p>
                        <h1 style="font-size:36px; letter-spacing:5px; margin:20px 0; color:#85461E;">' . $otp . '</h1>
                        <p style="font-size:14px; color:#888;">This code will expire in <b>5 minutes</b>.</p>
                        <a href="#" style="display:inline-block; margin-top:25px; background:#85461E; color:white; text-decoration:none; padding:12px 28px; border-radius:6px; font-size:15px;">Verify Now</a>
                    </div>
                    <div style="background:#f2f2f2; text-align:center; padding:15px; font-size:12px; color:#999;">
                        © ' . date("Y") . ' New Line Cinema. All rights reserved.
                    </div>
                </div>
            </div>';

            $mail->AltBody = "Your OTP code is: $otp";

            $mail->send();
            echo json_encode(["success" => "✅ OTP sent successfully!"]);
        } catch (Exception $e) {
            echo json_encode(["error" => "❌ Mailer Error: " . $mail->ErrorInfo]);
        }
        exit;
    }

    // === STEP 2: VERIFY OTP ===
    elseif ($_POST['action'] === "verify_otp" && isset($_POST['otp'])) {
        $enteredOtp = trim($_POST['otp']);

        if (isset($_SESSION['otp']) && isset($_SESSION['otp_expire'])) {
            if (time() > $_SESSION['otp_expire']) {
                $response = ["error" => "❌ OTP expired. Please request a new one."];
            } elseif ($enteredOtp == $_SESSION['otp']) {
                $_SESSION['verified_email'] = $_SESSION['email'];
                unset($_SESSION['otp'], $_SESSION['otp_expire']);
                $response = ["success" => "✅ OTP verified successfully!", "done" => true];
            } else {
                $response = ["error" => "❌ Invalid OTP. Please try again."];
            }
        } else {
            $response = ["error" => "❌ No OTP found. Please request one first."];
        }

        echo json_encode($response);
        exit;
    }

    echo json_encode(["error" => "Invalid action."]);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Bind Email</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
  <style>
    html, body {
      margin:0; padding:0; height:100%; background:#000;
      font-family:Arial; color:#fff;
    }
    .top-bar { height:40px; display:flex; align-items:center; padding:0 16px; background:#111; }
    .top-bar a { color:#fff; font-size:24px; text-decoration:none; }
    .top-bar-title { flex:1; text-align:center; font-size:16px; font-weight:bold; }
    .form-wrapper { padding:20px; padding-bottom:100px; }
    .form-group { margin-bottom:25px; }
    label { display:block; margin-bottom:8px; font-size:12px; }
    .input-wrapper { position:relative; }
    input[type="email"], input[type="text"] {
      width:100%; padding:12px 90px 12px 12px; background:#1c1c1c;
      border:none; border-radius:6px; color:#fff; font-size:16px;
    }
    .send-link {
      position:absolute; right:12px; top:45%; transform:translateY(-50%);
      color:#caa076; font-size:14px; background:none; border:none; cursor:pointer;
    }
    .ok-button {
      position: fixed; bottom: 0; left: 0; width: 100%; padding: 14px;
      border: none; color: white; font-size: 14px; font-weight: bold; cursor: pointer;
      border-top-left-radius: 12px; border-top-right-radius: 12px;
      background: linear-gradient(to right, #85461E, #caa076);
    }
    .toast {
      visibility:hidden; min-width:200px; background:#111; color:#fff; text-align:center;
      border-radius:6px; padding:12px; position:fixed; left:50%; top:30%;
      transform:translate(-50%, -50%); z-index:9999; opacity:0;
      transition:opacity 0.5s, top 0.5s;
    }
    .toast.show { visibility:visible; opacity:1; top:40%; }
  </style>
</head>
<body>

<div class="top-bar">
  <a href="dashboard.php">&#8592;</a>
  <div class="top-bar-title">Bind email</div>
</div>

<div class="form-wrapper">
  <form id="bind-form">
    <div class="form-group">
      <label>Email address</label>
      <div class="input-wrapper">
        <input type="email" name="email" id="email" placeholder="Please enter email" required>
      </div>
    </div>

    <div class="form-group">
      <label>Email verification code</label>
      <div class="input-wrapper">
        <input type="text" name="otp" id="otp" placeholder="Please enter verification code" required>
        <button type="button" id="sendOtp" class="send-link">Send</button>
      </div>
    </div>

    <button type="submit" id="okBtn" class="ok-button">Submit</button>
  </form>
</div>

<div id="toast" class="toast"></div>

<script>
  function showToast(message) {
    const toast = document.getElementById("toast");
    toast.innerText = message;
    toast.className = "toast show";
    setTimeout(() => toast.className = toast.className.replace("show", ""), 2000);
  }

  const form = document.getElementById('bind-form');
  const sendOtpBtn = document.getElementById('sendOtp');

  sendOtpBtn.addEventListener("click", () => {
    const email = document.getElementById('email').value;
    if (!email) return showToast("Enter email first");

    fetch("", {
      method: "POST",
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: new URLSearchParams({ action: "send_otp", email })
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) showToast(data.success);
      else showToast(data.error);
    });
  });

  form.addEventListener('submit', function (e) {
    e.preventDefault();
    const otp = document.getElementById('otp').value;

    fetch("", {
      method: "POST",
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: new URLSearchParams({ action: "verify_otp", otp })
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        showToast(data.success);
        if (data.done) {
          form.style.display = "none";
          setTimeout(() => location.reload(), 1500);
        }
      } else {
        showToast(data.error);
      }
    });
  });
</script>

</body>
</html>