<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$lang = $_SESSION['lang'] ?? 'en';

// Only translate if language is not English
if ($lang !== 'en') {
    function translateText($text, $lang) {
        $url = "https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl={$lang}&dt=t&q=" . urlencode($text);
        $response = @file_get_contents($url);
        if ($response === false) return $text;
        $result = json_decode($response, true);
        return $result[0][0][0] ?? $text;
    }

    ob_start(function ($buffer) use ($lang) {
        return preg_replace_callback('/>([^<]+)</', function ($matches) use ($lang) {
            $text = trim($matches[1]);
            if ($text === '' || strlen($text) < 2) return '>' . $text . '<';
            $translated = translateText($text, $lang);
            return '>' . htmlspecialchars($translated, ENT_QUOTES, 'UTF-8') . '<';
        }, $buffer);
    });
}
?>