<?php  
ini_set('display_errors', 1);  
ini_set('display_startup_errors', 1);  
error_reporting(E_ALL);  
session_start();  
include 'db.php';  

if (!isset($_SESSION['phone'])) {  
    header("Location: login.php");  
    exit();  
}  

$phone = $_SESSION['phone'];  

// Get user ID  
$stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");  
$stmt->execute([$phone]);  
$user = $stmt->fetch(PDO::FETCH_ASSOC);  
$user_id = $user['id'];  

// Withdrawals  
$stmt = $conn->prepare("SELECT amount, fee, status, created_at FROM withdrawals WHERE user_id = ? ORDER BY id DESC");  
$stmt->execute([$user_id]);  
$withdrawals = $stmt->fetchAll(PDO::FETCH_ASSOC);  

// Task Records  
$stmt = $conn->prepare("SELECT t.scored_at, t.amount, v.title  
                        FROM task_records t  
                        JOIN videos v ON t.video_id = v.id  
                        WHERE t.user_id = ?  
                        ORDER BY t.id DESC");  
$stmt->execute([$user_id]);  
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);  

// Recharge Records  
$stmt = $conn->prepare("SELECT amount, created_at, payment_method, status  
                        FROM recharge_records  
                        WHERE phone = ?  
                        ORDER BY id DESC");  
$stmt->execute([$phone]);  
$recharges = $stmt->fetchAll(PDO::FETCH_ASSOC);  

// ✅ Community Income (from assets table)  
$stmt = $conn->prepare("SELECT amount, description, created_at  
                        FROM assets  
                        WHERE user_id = ? AND type = 'community_income'  
                        ORDER BY id DESC");  
$stmt->execute([$user_id]);  
$community_income = $stmt->fetchAll(PDO::FETCH_ASSOC);  

// Referral Bonus (still from referral_bonus table, type = reward)  
$referrals = [];  
if ($conn->query("SHOW TABLES LIKE 'referral_bonus'")->rowCount() > 0) {  
    $stmt = $conn->prepare("SELECT amount, created_at  
                            FROM referral_bonus  
                            WHERE user_id = ? AND type = 'reward'  
                            ORDER BY id DESC");  
    $stmt->execute([$user_id]);  
    $referrals = $stmt->fetchAll(PDO::FETCH_ASSOC);  
}  

// VIP Purchases (with expiry)  
$stmt = $conn->prepare("SELECT v.name, p.amount, p.purchased_at AS purchase_date,  
                               DATE_ADD(p.purchased_at, INTERVAL v.valid_days DAY) AS expiry_date  
                        FROM purchases p  
                        JOIN vip_products v ON p.vip_product_id = v.id  
                        WHERE p.user_id = ?  
                        ORDER BY p.id DESC");  
$stmt->execute([$user_id]);  
$purchases = $stmt->fetchAll(PDO::FETCH_ASSOC);  
?>  

<!DOCTYPE html>  
<html lang="en">  
<head>  
<meta charset="UTF-8" />  
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover"/>  
<title>Asset Details</title>  
<script src="https://cdn.tailwindcss.com"></script>  
<script>  
function setFilter(type) {  
    document.getElementById('filter-btn').innerText = type;  
    const all = document.querySelectorAll('[data-record]');  
    all.forEach(el => el.style.display = (type === 'All' || el.dataset.record === type) ? 'block' : 'none');  
}  
</script>  
</head>  

<body class="bg-black text-white font-sans">  
<div class="max-w-md mx-auto min-h-screen flex flex-col justify-between pt-2">  

  <!-- Header -->  
  <div class="p-4 border-b border-gray-700 flex justify-between items-center">  
    <div class="text-lg font-semibold">Asset Details</div>  
    <a href="task_record.php" class="text-sm text-gray-400">Score record</a>  
  </div>  

  <!-- Filter Dropdown -->  
  <div class="flex justify-between items-center px-4 pt-2">  
    <div class="relative">  
      <button id="filter-btn" class="bg-gray-800 px-3 py-1 rounded text-sm"  
              onclick="document.getElementById('filter-menu').classList.toggle('hidden')">All ▾</button>  
      <div id="filter-menu" class="absolute z-10 bg-gray-800 mt-2 rounded shadow hidden text-sm">  
        <div onclick="setFilter('All')" class="px-4 py-2 hover:bg-gray-700 cursor-pointer">All</div>  
        <div onclick="setFilter('Recharge')" class="px-4 py-2 hover:bg-gray-700 cursor-pointer">Recharge Record</div>  
        <div onclick="setFilter('Withdraw')" class="px-4 py-2 hover:bg-gray-700 cursor-pointer">Withdraw Record</div>  
        <div onclick="setFilter('Task')" class="px-4 py-2 hover:bg-gray-700 cursor-pointer">Task Record</div>  
        <div onclick="setFilter('Community')" class="px-4 py-2 hover:bg-gray-700 cursor-pointer">Community Income</div>  
        <div onclick="setFilter('Referral')" class="px-4 py-2 hover:bg-gray-700 cursor-pointer">Referral Bonus</div>  
        <div onclick="setFilter('VIP')" class="px-4 py-2 hover:bg-gray-700 cursor-pointer">VIP Record</div>  
      </div>  
    </div>  
  </div>  

  <!-- Records -->  
  <div class="px-4 mt-4 space-y-3">  

    <!-- Withdrawals -->  
    <?php foreach ($withdrawals as $r): ?>  
    <div class="bg-gray-900 p-3 rounded shadow" data-record="Withdraw">  
      <div class="flex justify-between text-sm">  
        <div>  
          <div class="font-medium">Withdraw</div>  
          <div class="text-gray-400 text-xs"><?= date('m/d/Y H:i:s', strtotime($r['created_at'])) ?></div>  
        </div>  
        <div class="text-right">  
          <div class="text-yellow-400 font-semibold">-<?= number_format($r['amount'], 2) ?> USDT</div>  
          <div class="text-green-500 text-xs">Status: <?= htmlspecialchars($r['status']) ?></div>  
        </div>  
      </div>  
    </div>  
    <?php endforeach; ?>  

    <!-- Recharges -->  
    <?php foreach ($recharges as $r): ?>  
    <div class="bg-gray-900 p-3 rounded shadow" data-record="Recharge">  
      <div class="flex justify-between text-sm">  
        <div>  
          <div class="font-medium">Recharge</div>
          
          <div class="text-gray-400 text-xs"><?= date('m/d/Y H:i:s', strtotime($r['created_at'])) ?></div>  
        </div>  
        <div class="text-right">  
          <div class="text-green-400 font-semibold">+<?= number_format($r['amount'], 2) ?> USDT</div>  
          <div class="text-sm text-yellow-400"><?= ucfirst($r['status']) ?></div>  
        </div>  
      </div>  
    </div>  
    <?php endforeach; ?>  

    <!-- Tasks -->  
    <?php foreach ($tasks as $t): ?>  
    <div class="bg-gray-900 p-3 rounded shadow" data-record="Task">  
      <div class="flex justify-between text-sm">  
        <div>  
          <div class="font-medium">Task: <?= htmlspecialchars($t['title']) ?></div>  
          <div class="text-gray-400 text-xs"><?= date('m/d/Y H:i:s', strtotime($t['scored_at'])) ?></div>  
        </div>  
        <div class="text-right">  
          <div class="text-green-400 font-semibold">+<?= number_format($t['amount'], 2) ?> USDT</div>  
        </div>  
      </div>  
    </div>  
    <?php endforeach; ?>  

    <!-- Community Income (rebates) -->  
    <?php foreach ($community_income as $r): ?>  
    <div class="bg-gray-900 p-3 rounded shadow" data-record="Community">  
      <div class="flex justify-between text-sm">  
        <div>  
          <div class="font-medium text-white">Community Income</div>  
          <div class="text-gray-400 text-xs"><?= date('m/d/Y H:i:s', strtotime($r['created_at'])) ?></div>  
          <!-- description removed -->  
        </div>  
        <div class="text-right">  
          <div class="text-green-400 font-semibold">+<?= number_format((float)$r['amount'], 2) ?> USDT</div>  
        </div>  
      </div>  
    </div>  
    <?php endforeach; ?>  

    <!-- Referral Bonus (reward only) -->  
    <?php foreach ($referrals as $r): ?>  
    <div class="bg-gray-900 p-3 rounded shadow" data-record="Referral">  
      <div class="flex justify-between text-sm">  
        <div>  
          <div class="font-medium text-white">Referral Bonus</div>  
          <div class="text-gray-400 text-xs"><?= date('m/d/Y H:i:s', strtotime($r['created_at'])) ?></div>  
        </div>  
        <div class="text-right">  
          <div class="text-green-400 font-semibold">+<?= number_format((float)$r['amount'], 2) ?> USDT</div>  
        </div>  
      </div>  
    </div>  
    <?php endforeach; ?>  

    <!-- VIP Purchases -->  
    <?php foreach ($purchases as $p): ?>  
    <div class="bg-gray-900 p-3 rounded shadow" data-record="VIP">  
      <div class="flex justify-between text-sm">  
        <div>  
          <div class="font-medium">  
            <span class="inline-block w-2 h-2 bg-yellow-400 rounded-full mr-1"></span>  
            VIP Purchase: <?= htmlspecialchars($p['name']) ?>  
          </div>  
          <div class="text-gray-400 text-xs">  
            Purchase: <?= !empty($p['purchase_date']) ? date('m/d/Y H:i:s', strtotime($p['purchase_date'])) : 'N/A' ?><br>  
            Expiry: <?= !empty($p['expiry_date']) ? date('m/d/Y', strtotime($p['expiry_date'])) : 'N/A' ?>  
          </div>  
        </div>  
        <div class="text-right">  
          <div class="text-yellow-400 font-semibold">-<?= number_format((float)($p['amount'] ?? 0), 2) ?> USDT</div>  
        </div>  
      </div>  
    </div>  
    <?php endforeach; ?>  

  </div>  

  <!-- Footer -->  
  <div class="text-center text-gray-500 text-sm mt-6 mb-16">No more</div>  
  <?php include 'bottom_nav.php'; ?>  

</div>  
</body>  
</html>