<?php
session_start();
if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

include 'db.php';
$phone = $_SESSION['phone'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>About Us</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      background: linear-gradient(180deg, #FFFFFF 0%, #FFEAB6 100%);
      color: #2E2E2E;
      font-family: 'Poppins', sans-serif;
      line-height: 1.6;
    }

    .top-header {
      background: #000;
      color: #FFD700;
      text-align: center;
      padding: 15px;
      font-size: 20px;
      font-weight: bold;
      border-bottom: 3px solid #FFD700;
    }

    .container {
      max-width: 900px;
      margin: 0 auto;
      padding: 30px 20px;
    }

    .about-section {
      text-align: center;
      margin-bottom: 40px;
    }

    .about-section h1 {
      color: #000;
      font-size: 26px;
      margin-bottom: 10px;
    }

    .about-section p {
      font-size: 16px;
      color: #333;
      margin-bottom: 15px;
    }

    .mission, .vision {
      background-color: rgba(255, 255, 255, 0.6);
      padding: 20px;
      border-radius: 10px;
      margin-bottom: 25px;
      border: 1px solid #FFD70055;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    .mission h2, .vision h2 {
      color: #B8860B;
      margin-bottom: 10px;
    }

    .mission p, .vision p {
      color: #444;
      font-size: 15px;
    }

    .team {
      text-align: center;
      margin-top: 40px;
    }

    .team h2 {
      color: #B8860B;
      margin-bottom: 15px;
    }

    .team p {
      color: #333;
      font-size: 15px;
      max-width: 700px;
      margin: 0 auto;
    }

    .footer {
      text-align: center;
      padding: 20px;
      background: #000;
      color: #FFD700;
      font-size: 14px;
      border-top: 3px solid #FFD700;
      margin-top: 40px;
    }

    .highlight {
      color: #B8860B;
      font-weight: bold;
    }

    @media (max-width: 600px) {
      .about-section h1 {
        font-size: 22px;
      }
      .mission, .vision {
        padding: 15px;
      }
    }
  </style>
</head>
<body>

  <div class="top-header">About Us</div>

  <div class="container">

    <div class="about-section">
      <h1>Welcome to <span class="highlight">New Line Cinema</span></h1>
      <p>
        We are a next-generation entertainment and digital rewards platform where users can 
        <span class="highlight">watch movies, complete simple tasks, and earn real rewards.</span>
        Our mission is to make online entertainment both fun and financially rewarding.
      </p>
    </div>

    <div class="mission">
      <h2>🎯 Our Mission</h2>
      <p>
        To provide users worldwide with a secure and innovative platform where 
        leisure and income come together. At New Line Cinema, we believe your time online 
        should be both entertaining and rewarding.
      </p>
    </div>

    <div class="vision">
      <h2>🌍 Our Vision</h2>
      <p>
        Our vision is to revolutionize the entertainment industry by creating a 
        community-driven ecosystem that combines technology, creativity, and rewards — 
        empowering everyone to benefit from the digital economy.
      </p>
    </div>

    <div class="team">
      <h2>🤝 Our Team</h2>
      <p>
        Behind <span class="highlight">New Line Cinema</span> is a dedicated team of innovators, 
        developers, and media professionals. We are united by a common goal: 
        to build a trusted, rewarding, and enjoyable entertainment experience for everyone.
      </p>
    </div>
  </div>

  <div class="footer">
    &copy; <?php echo date("Y"); ?> New Line Cinema. All Rights Reserved.
  </div>

</body>
</html>