<?php
session_start();
include 'db.php';

// Check if user is logged in
if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];
$vip = $_GET['vip'] ?? 'VIP0';
$today = date('Y-m-d');

// Get user ID from phone
$stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$user_id = $user['id'] ?? null;

if (!$user_id) {
    die("Invalid user.");
}

// Check if task already completed today
$stmt = $conn->prepare("SELECT * FROM task_records WHERE user_id = ? AND vip_level = ? AND completed_at = ?");
$stmt->execute([$user_id, $vip, $today]);
$task_done = $stmt->fetch();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$task_done) {
    $rating = $_POST['rating'];

    // Get video earning from vip_products
    $stmt = $conn->prepare("SELECT view_income FROM vip_products WHERE vip_level = ?");
    $stmt->execute([$vip]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);
    $earning = $product['view_income'] ?? 1.00;

    // Record task
    $stmt = $conn->prepare("INSERT INTO task_records (user_id, vip_level, rating, completed_at) VALUES (?, ?, ?, ?)");
    $stmt->execute([$user_id, $vip, $rating, $today]);

    // Update user balance
    $stmt = $conn->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
    $stmt->execute([$earning, $user_id]);

    echo "<script>alert('You earned $$earning for completing your $vip task.'); window.location.href='account.php';</script>";
    exit();
}

// Video selection per VIP
$videos = [
    'VIP0' => 'videos/vip0.mp4',
    'VIP1' => 'videos/vip1.mp4',
    'VIP2' => 'videos/vip2.mp4',
    'VIP3' => 'videos/vip3.mp4',
    'VIP4' => 'videos/vip4.mp4',
    'VIP5' => 'videos/vip5.mp4',
];
$video_url = $videos[$vip] ?? 'videos/default.mp4';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title><?= htmlspecialchars($vip) ?> Task</title>
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #f3f3f3;
      padding: 20px;
      color: #333;
    }
    .container {
      background: #fff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
      max-width: 600px;
      margin: auto;
    }
    h2 {
      text-align: center;
      color: maroon;
    }
    video {
      width: 100%;
      border-radius: 10px;
      margin: 15px 0;
    }
    form {
      text-align: center;
      margin-top: 20px;
    }
    select {
      padding: 10px;
      border-radius: 6px;
      border: 1px solid #ccc;
      width: 100%;
      margin-bottom: 15px;
      font-size: 16px;
    }
    button {
      background: maroon;
      color: white;
      border: none;
      padding: 12px 25px;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
    }
    button:disabled {
      background: #aaa;
    }
    .message {
      text-align: center;
      font-size: 16px;
      padding: 15px;
      background: #e6ffe6;
      border: 1px solid #b2ffb2;
      border-radius: 8px;
      margin-top: 20px;
      color: green;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2><?= htmlspecialchars($vip) ?> Video Task</h2>

    <video controls>
      <source src="<?= htmlspecialchars($video_url) ?>" type="video/mp4">
      Your browser does not support the video tag.
    </video>

    <?php if ($task_done): ?>
      <div class="message">✅ You’ve already completed this task today for <?= htmlspecialchars($vip) ?>.</div>
    <?php else: ?>
      <form method="post">
        <label for="rating">Rate this video:</label><br>
        <select name="rating" required>
          <option value="">-- Select Rating --</option>
          <option value="5">⭐️⭐️⭐️⭐️⭐️ (Excellent)</option>
          <option value="4">⭐️⭐️⭐️⭐️ (Good)</option>
          <option value="3">⭐️⭐️⭐️ (Average)</option>
          <option value="2">⭐️⭐️ (Poor)</option>
          <option value="1">⭐️ (Very Bad)</option>
        </select>
        <br>
        <button type="submit">Submit & Claim Reward</button>
      </form>
    <?php endif; ?>
  </div>
</body>
</html>