?php ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); 
session_start();
include 'db.php';

if (!isset($_SESSION['phone'])) {
    header("Location: login.php");
    exit();
}

$phone = $_SESSION['phone'];

// Fetch user info
$stmt = $conn->prepare("SELECT * FROM users WHERE phone = ?");
$stmt->execute([$phone]);
$user = $stmt->fetch();

if (!$user) {
    echo "User not found.";
    exit();
}

// VIP product definitions
$vip_levels = [
    'VIP0' => ['daily_earning' => 0.5, 'validity' => '15 days'],
    'VIP1' => ['daily_earning' => 1.0, 'validity' => '30 days'],
    'VIP2' => ['daily_earning' => 3.0, 'validity' => '30 days'],
    'VIP3' => ['daily_earning' => 5.0, 'validity' => '30 days'],
    'VIP4' => ['daily_earning' => 8.0, 'validity' => '30 days'],
    'VIP5' => ['daily_earning' => 12.0, 'validity' => '30 days'],
    'VIP6' => ['daily_earning' => 20.0, 'validity' => '30 days'],
    'VIP7' => ['daily_earning' => 30.0, 'validity' => '30 days'],
    'VIP8' => ['daily_earning' => 50.0, 'validity' => '30 days'],
    'VIP9' => ['daily_earning' => 80.0, 'validity' => '30 days'],
    'VIP10' => ['daily_earning' => 100.0, 'validity' => '30 days'],
];

// Get completed VIP tasks today
$today = date('Y-m-d');
$completed = [];
$stmt = $conn->prepare("SELECT vip_level FROM task_records WHERE phone = ? AND completed_at = ?");
$stmt->execute([$phone, $today]);
while ($row = $stmt->fetch()) {
    $completed[] = $row['vip_level'];
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>VIP Product Tasks</title>
    <style>
        body {
            font-family: Arial;
            background: #f2f2f2;
            margin: 0;
            padding: 20px;
        }
        .vip-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .vip-card h3 {
            margin: 0 0 10px;
            color: maroon;
        }
        .vip-card .btn {
            margin-top: 10px;
            padding: 8px 16px;
            background: maroon;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            display: inline-block;
        }
        .vip-card .btn.disabled {
            background: gray;
            pointer-events: none;
        }
    </style>
</head>
<body>

<h2>VIP Product Tasks</h2>

<?php foreach ($vip_levels as $level => $info): ?>
    <div class="vip-card">
        <h3><?= $level ?></h3>
        <p>Daily Earnings: $<?= $info['daily_earning'] ?></p>
        <p>Validity: <?= $info['validity'] ?></p>

        <?php if (in_array($level, $completed)): ?>
            <p style="color: green;">Task Completed Today</p>
            <a class="btn disabled">Done</a>
        <?php else: ?>
            <a class="btn" href="video_task.php?vip=<?= urlencode($level) ?>">Watch Video</a>
        <?php endif; ?>
    </div>
<?php endforeach; ?>

</body>
</html>