<?php
include 'db.php';

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $country_code = $_POST['country_code'] ?? '';
  $phone = $_POST['phone'] ?? '';
  $password = $_POST['password'] ?? '';
  $confirm = $_POST['confirm_password'] ?? '';
  $invite = $_POST['invite_code'] ?? '';
  $agree = isset($_POST['agree']);

  if (!$country_code || !$phone || !$password || !$confirm || !$agree) {
    $error = "Please fill all fields and agree to the policy.";
  } elseif ($password !== $confirm) {
    $error = "Passwords do not match.";
  } else {
    $full_phone = $country_code . $phone;
    $hashed = password_hash($password, PASSWORD_DEFAULT);

    // Generate unique invite code (you can change this to your preferred logic)
    $my_invite_code = substr(str_shuffle('ABCDEFGHJKLMNPQRSTUVWXYZ23456789'), 0, 6);

    $stmt = $conn->prepare("INSERT INTO users (phone, password, invite_code, invited_by) VALUES (?, ?, ?, ?)");
    if ($stmt->execute([$full_phone, $hashed, $my_invite_code, $invite])) {
      echo "<script>alert('Registration successful! Redirecting to login...'); window.location.href='login.php';</script>";
      exit;
    } else {
      $error = "Error saving data. Possibly duplicate phone or invite code.";
    }
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Register</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <style>
    * { box-sizing: border-box; }
    body, html {
      margin: 0;
      padding: 0;
      height: 100%;
      font-family: Arial, sans-serif;
      background: url('background.jpg') no-repeat center top;
      background-size: cover;
      overflow: hidden;
    }

    .background-blur {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      background: rgba(0, 0, 0, 0.2);
      z-index: 0;
    }

    .overlay {
      position: absolute;
      top: 70%;
      left: 0;
      width: 100%;
      height: 30%;
      backdrop-filter: blur(40px);
      -webkit-backdrop-filter: blur(40px);
      border-top-left-radius: 30px;
      border-top-right-radius: 30px;
      z-index: 1;
    }

    .form-container {
      position: absolute;
      top: 55%;
      left: 50%;
      transform: translate(-50%, -50%);
      width: 90%;
      max-width: 400px;
      z-index: 2;
    }

    .logo-container {
      text-align: center;
      margin-top: 60px;
      z-index: 2;
      position: relative;
    }

    .logo-container img {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      object-fit: cover;
      border: 3px solid white;
    }

    .form-box {
      background: rgba(0, 0, 0, 0.4);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      border-radius: 15px;
      padding: 18px 12px;
      margin-bottom: 12px;
      color: white;
      border: none;
      width: 100%;
    }

    .form-box::placeholder {
      color: #ccc;
    }

    .phone-group {
      display: flex;
      margin-bottom: 12px;
    }

    .country-code {
      padding: 18px 10px;
      border-radius: 10px 0 0 10px;
      border: none;
      background-color: rgba(0, 0, 0, 0.3);
      color: #FFD700;
      font-weight: bold;
      backdrop-filter: blur(6px);
      -webkit-backdrop-filter: blur(6px);
    }

    .phone-input {
      flex: 1;
      padding: 18px 10px;
      border: none;
      border-radius: 0 10px 10px 0;
      background-color: rgba(0, 0, 0, 0.3);
      color: #FFD700;
      backdrop-filter: blur(6px);
      -webkit-backdrop-filter: blur(6px);
    }

    .register-button {
      width: 100%;
      padding: 14px;
      margin-top: 8px;
      background: linear-gradient(to right, #a700ff, #ff0076);
      border: none;
      border-radius: 30px;
      color: white;
      font-size: 22px;
      font-weight: bold;
    }

    .bottom-text {
      text-align: center;
      color: white;
      font-size: 14px;
      margin-top: 10px;
    }

    .bottom-text a {
      color: #ff6ec4;
      text-decoration: none;
    }

    .checkbox-text {
      font-size: 13px;
      color: white;
      margin-top: 5px;
      margin-bottom: 15px;
    }

    .checkbox-text input {
      margin-right: 6px;
    }
  </style>
</head>
<body>
  <div class="background-blur"></div>
  <div class="logo-container">
    <img src="logo.png" alt="Logo">
  </div>
  <div class="overlay"></div>
  <div class="form-container">
    <form method="POST">
      <div class="phone-group">
        <select name="country_code" class="country-code">
          <option value="+234" selected>+234 🇳🇬</option>
          <option value="+1">+1 🇺🇸</option>
          <option value="+44">+44 🇬🇧</option>
          <option value="+91">+91 🇮🇳</option>
          <option value="+81">+81 🇯🇵</option>
          <option value="+86">+86 🇨🇳</option>
          <option value="+33">+33 🇫🇷</option>
          <option value="+49">+49 🇩🇪</option>
          <option value="+61">+61 🇦🇺</option>
          <option value="+27">+27 🇿🇦</option>
        </select>
        <input type="text" name="phone" class="phone-input" placeholder="Enter phone number" required>
      </div>

      <input type="password" name="password" class="form-box" placeholder="Login password (6-20 digits/letters)" required>
      <input type="password" name="confirm_password" class="form-box" placeholder="Confirm password" required>
      <input type="text" name="invite_code" class="form-box" placeholder="Enter invitation code" required>

      <div class="checkbox-text">
        <label><input type="checkbox" name="agree" required> I have read and agree to the <a href="#">User Agreement</a> and <a href="#">Privacy Policy</a></label>
      </div>

      <button type="submit" class="register-button">Register Now</button>

      <div class="bottom-text">
        Already have an account? <a href="login.php">Login now</a>
      </div>
    </form>
  </div>
</body>
</html>
