<?php    
session_start();    
include 'db.php';    
  
$message = '';  
  
if ($_SERVER['REQUEST_METHOD'] === 'POST') {    
  $country_code = $_POST['country_code'];    
  $phone_number = $_POST['phone'];    
  $password = $_POST['password'];    
  
  $full_phone = $country_code . $phone_number;  
  
  $stmt = $conn->prepare("SELECT * FROM users WHERE phone = ?");    
  $stmt->execute([$full_phone]);    
  
  if ($stmt->rowCount() > 0) {    
    $user = $stmt->fetch();    
  
    if (password_verify($password, $user['password'])) {    
      // Login success    
      $_SESSION['user_id'] = $user['id'];    
      echo "<script>    
        setTimeout(function() {    
          Swal.fire({    
            icon: 'success',    
            title: 'Login successful!',    
            timer: 2000,    
            showConfirmButton: false    
          });    
          setTimeout(function() {    
            window.location.href = 'dashboard.php';    
          }, 2000);    
        }, 500);    
      </script>";    
    } else {    
      $message = "Invalid password.";    
    }    
  } else {    
    $message = "Account not found.";    
  }    
}    
?>    <!DOCTYPE html>    <html lang="en">    
<head>    
  <meta charset="UTF-8">    
  <title>Login</title>    
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">    
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>    
  <style>    
    * { box-sizing: border-box; }    
    body, html {    
      margin: 0;    
      padding: 0;    
      height: 100%;    
      font-family: Arial, sans-serif;    
      background: url('background.jpg') no-repeat center top;    
      background-size: cover;    
      overflow: hidden;    
    }    
    .background-blur {    
      position: fixed;    
      top: 0;    
      left: 0;    
      width: 100%;    
      height: 100%;    
      backdrop-filter: blur(10px);    
      background: rgba(0, 0, 0, 0.2);    
      z-index: 0;    
    }    
    .overlay {    
      position: absolute;    
      top: 50%;    
      left: 0;    
      width: 100%;    
      height: 50%;    
      background: rgba(0, 0, 0, 0.4);    
      backdrop-filter: blur(40px);    
      border-top-left-radius: 30px;    
      border-top-right-radius: 30px;    
      z-index: 1;    
    }    
    .form-container {    
      position: absolute;    
      top: 55%;    
      left: 50%;    
      transform: translate(-50%, -50%);    
      width: 90%;    
      max-width: 400px;    
      z-index: 2;    
    }    
    .logo-container {    
      text-align: center;    
      margin-top: 60px;    
      z-index: 2;    
      position: relative;    
    }    
    .logo-container img {    
      width: 100px;    
      height: 100px;    
      border-radius: 50%;    
      object-fit: cover;    
      border: 3px solid white;    
    }    
    .form-box {    
      background: rgba(0, 0, 0, 0.4);    
      backdrop-filter: blur(10px);    
      border-radius: 15px;    
      padding: 20px 12px;    
      margin-bottom: 12px;    
      color: white;    
      width: 100%;    
      border: none;    
    }    
    .form-box::placeholder {    
      color: #ccc;    
    }    
    .phone-group {    
      display: flex;    
      margin-bottom: 12px;    
    }    
    .country-code {    
      padding: 18px 10px;    
      border-radius: 10px 0 0 10px;    
      border: none;    
      background-color: rgba(0, 0, 0, 0.3);    
      color: #FFD700;    
      font-weight: bold;    
    }    
    .phone-input {    
      flex: 1;    
      padding: 18px 10px;    
      border: none;    
      border-radius: 0 10px 10px 0;    
      background-color: rgba(0, 0, 0, 0.3);    
      color: #FFD700;    
    }    
    .login-button {    
      width: 100%;    
      padding: 14px;    
      margin-top: 8px;    
      background: linear-gradient(to right, #a700ff, #ff0076);    
      border: none;    
      border-radius: 30px;    
      color: white;    
      font-size: 22px;    
      font-weight: bold;    
    }    
    .bottom-text {    
      text-align: center;    
      color: white;    
      font-size: 14px;    
      margin-top: 10px;    
    }    
    .bottom-text a {    
      color: #ff6ec4;    
      text-decoration: none;    
    }    
    .swal2-popup {    
      width: 260px !important;    
      background-color: rgba(0, 0, 0, 0.8) !important;    
      backdrop-filter: blur(6px);    
      color: white;    
      font-size: 14px;    
      border-radius: 12px;    
    }    
  </style>    
</head>    
<body>    
  <div class="background-blur"></div>    
  <div class="logo-container">    
    <img src="logo.png" alt="Logo">    
  </div>    
  <div class="overlay"></div>    
  <div class="form-container">    
    <form method="POST" action="">    
      <div class="phone-group">    
        <select name="country_code" class="country-code">    
          <option value="+234" selected>+234 🇳🇬</option>    
          <option value="+1">+1 🇺🇸</option>    
          <option value="+44">+44 🇬🇧</option>    
          <option value="+91">+91 🇮🇳</option>    
          <option value="+81">+81 🇯🇵</option>    
          <option value="+86">+86 🇨🇳</option>    
          <option value="+33">+33 🇫🇷</option>    
          <option value="+49">+49 🇩🇪</option>    
          <option value="+61">+61 🇦🇺</option>    
          <option value="+27">+27 🇿🇦</option>    
        </select>    
        <input type="text" name="phone" class="phone-input" placeholder="Enter phone number" required>    
      </div>    
      <input type="password" name="password" class="form-box" placeholder="Password" required>    
      <button type="submit" class="login-button">Login</button>    
      <div class="bottom-text">    
        No account? <a href="register.php">Register now</a>    
      </div>    
    </form>    
    <?php if (!empty($message)) { ?>    
      <script>    
        Swal.fire({    
          icon: 'error',    
          title: 'Oops!',    
          text: "<?php echo $message; ?>",    
          timer: 2500,    
          showConfirmButton: false    
        });    
      </script>    
    <?php } ?>    
  </div>    
</body>    
</html>