<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

include 'db.php'; // Your database connection

$userId = $_SESSION['user_id'];

// Use PDO-style parameter binding
$query = $conn->prepare("SELECT vip_level, vip_expiry, total_tasks, today_tasks FROM users WHERE id = ?");
$query->execute([$userId]);
$user = $query->fetch(PDO::FETCH_ASSOC);

$vipLevel = $user['vip_level'] ?? 'VIP0';
$vipExpiry = $user['vip_expiry'] ?? 'N/A';
$totalTasks = $user['total_tasks'] ?? 0;
$todayTasks = $user['today_tasks'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>CVN Dashboard</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
    }

    .marquee {
      overflow: hidden;
      position: relative;
      background-color: #000000cc;
    }

    .marquee div {
      display: inline-block;
      white-space: nowrap;
      padding-left: 100%;
      animation: marquee 12s linear infinite;
      color: #facc15;
      font-weight: bold;
    }

    @keyframes marquee {
      0% { transform: translateX(0%); }
      100% { transform: translateX(-100%); }
    }
  </style>
</head>
<body class="relative text-white min-h-screen">

  <!-- 🔁 Background Image -->
  <div class="absolute inset-0 bg-cover bg-center" style="background-image: url('logo.jpg'); z-index: -2;"></div>
  <div class="absolute inset-0 bg-black/60 backdrop-blur-sm z-0"></div>

  <!-- 🔔 Moving Notification Bar -->
  <div class="marquee z-10 relative text-sm py-1">
    <div>⚠️ CVN Platform Notice: Beware of fake platforms, don’t share your login info, and always confirm official domains. Stay secure! ⚠️</div>
  </div>

  <!-- 🔲 Main Content -->
  <div class="relative z-10 p-4">

    <!-- Header -->
    <div class="flex items-center justify-between mb-4">
      <img src="logo.pgp" class="h-8" alt="CVN Logo">
      <div class="text-sm text-gray-300">Safety Tips: <span class="text-yellow-400"></span></div>
      
      <div class="flex space-x-4 relative items-center">
        <i class="fas fa-lock"></i>

        <!-- 🔔 Notification Bell -->
        <div class="relative">
          <i class="fas fa-bell text-white text-lg"></i>
          <span class="absolute -top-1 -right-2 bg-red-500 text-xs text-white rounded-full w-5 h-5 flex items-center justify-center">3</span>
        </div>

        <i class="fas fa-globe"></i>
      </div>
    </div>

    <!-- Icon Grid -->
    <div class="grid grid-cols-3 gap-4 text-center mb-6 text-white">
      <a href="#" class="flex flex-col items-center">
        <div class="bg-purple-500 p-4 rounded-full w-14 h-14 flex items-center justify-center text-xl">
          <i class="fas fa-building"></i>
        </div>
        <div class="mt-2 text-sm">Company Profile</div>
      </a>

      <a href="#" class="flex flex-col items-center">
        <div class="bg-indigo-500 p-4 rounded-full w-14 h-14 flex items-center justify-center text-xl">
          <i class="fas fa-desktop"></i>
        </div>
        <div class="mt-2 text-sm">Platform Intro</div>
      </a>

      <a href="#" class="flex flex-col items-center">
        <div class="bg-cyan-500 p-4 rounded-full w-14 h-14 flex items-center justify-center text-xl">
          <i class="fas fa-video"></i>
        </div>
        <div class="mt-2 text-sm">Video Tutorial</div>
      </a>

      <a href="#" class="flex flex-col items-center">
        <div class="bg-yellow-500 p-4 rounded-full w-14 h-14 flex items-center justify-center text-xl">
          <i class="fas fa-wallet"></i>
        </div>
        <div class="mt-2 text-sm">Financial Mgmt</div>
      </a>

      <a href="#" class="flex flex-col items-center">
        <div class="bg-blue-500 p-4 rounded-full w-14 h-14 flex items-center justify-center text-xl">
          <i class="fas fa-coins"></i>
        </div>
        <div class="mt-2 text-sm">Recharge Assets</div>
      </a>

      <a href="#" class="flex flex-col items-center">
        <div class="bg-green-500 p-4 rounded-full w-14 h-14 flex items-center justify-center text-xl">
          <i class="fas fa-hand-holding-usd"></i>
        </div>
        <div class="mt-2 text-sm">Withdrawal</div>
      </a>
    </div>

    <!-- VIP Card -->
    <div class="bg-purple-900/40 backdrop-blur rounded-xl p-4 mb-4">
      <div class="flex justify-between items-center">
        <div>
          <h2 class="text-lg font-bold text-purple-300"><?php echo htmlspecialchars($vipLevel); ?></h2>
          <p class="text-sm text-gray-300">Expiration: <?php echo htmlspecialchars($vipExpiry); ?></p>
        </div>
        <img src="https://via.placeholder.com/40?text=VIP" class="w-10 h-10" alt="VIP Badge">
      </div>
    </div>

    <!-- Tasks -->
    <div class="flex justify-between gap-4 mb-6">
      <div class="bg-[#2b2b2b]/60 backdrop-blur-sm p-4 rounded-xl flex-1 text-center">
        <div class="text-pink-400 font-bold text-lg"><?php echo number_format($totalTasks, 3); ?></div>
        <div class="text-sm text-gray-300">Total tasks</div>
      </div>
      <div class="bg-[#2b2b2b]/60 backdrop-blur-sm p-4 rounded-xl flex-1 text-center">
        <div class="text-yellow-300 font-bold text-lg"><?php echo number_format($todayTasks, 1); ?></div>
        <div class="text-sm text-gray-300">Today's tasks</div>
      </div>
    </div>

    <!-- Invite Friends -->
    <div class="bg-purple-800/30 backdrop-blur p-4 rounded-xl mb-4 flex items-center justify-between">
      <div>
        <h3 class="font-bold">Invite friends</h3>
        <p class="text-sm text-gray-300">Invite friends and make money</p>
      </div>
      <div class="w-10 h-10 bg-white text-purple-800 flex items-center justify-center rounded-full">
        🎁
      </div>
    </div>

    <!-- CVN Agent -->
    <div class="bg-[#1f1f1f]/50 backdrop-blur p-4 rounded-xl mb-20">
      <h3 class="font-bold">CVN Agent</h3>
      <p class="text-sm text-gray-300">CVN Agent</p>
    </div>
  </div>

  <!-- Bottom Nav -->
  <div class="fixed bottom-0 left-0 right-0 bg-black/80 backdrop-blur p-3 flex justify-around items-center border-t border-gray-700 z-10">
    <div class="text-purple-400 text-center">
      <i class="fas fa-home text-lg"></i>
      <div class="text-xs">Home</div>
    </div>
    <div class="text-white text-center">
      <i class="fas fa-bullhorn text-lg"></i>
      <div class="text-xs">Promotion</div>
    </div>
    <div class="text-white text-center">
      <div class="bg-purple-500 rounded-full px-3 py-1 text-xs">03:06</div>
    </div>
    <div class="text-white text-center">
      <i class="fas fa-crown text-lg"></i>
      <div class="text-xs">VIP</div>
    </div>
    <div class="text-white text-center">
      <i class="fas fa-user text-lg"></i>
      <div class="text-xs">Profile</div>
    </div>
  </div>

  <?php include 'bottom_nav.php'; ?>

  <!-- Font Awesome -->
  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>